% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{PrintPCA}
\alias{PrintPCA}
\title{Print the results of a PCA analysis}
\usage{
PrintPCA(object, pcs.print = 1:5, genes.print = 30, use.full = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{pcs.print}{Set of PCs to print genes for}

\item{genes.print}{Number of genes to print for each PC}

\item{use.full}{Use full PCA (i.e. the projected PCA, by default FALSE)}
}
\value{
Only text output
}
\description{
Prints a set of genes that most strongly define a set of principal components
}
\examples{
pbmc_small
PrintPCA(object = pbmc_small)
# Options for how many dimensions and how many genes to print
PrintPCA(object = pbmc_small, pcs.print = 1:2, genes.print = 5)
# Can also print for the projected PCA
PrintPCA(object = pbmc_small, use.full = TRUE)

}
