% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.phi.omni.R
\name{test.phi.omni}
\alias{test.phi.omni}
\title{calculate the right-tail probability of omnibus phi-divergence statistics under general correlation matrix.}
\usage{
test.phi.omni(prob, M, K0, K1, S, onesided = FALSE)
}
\arguments{
\item{prob}{- vector of input p-values.}

\item{M}{- correlation matrix of input statistics (of the input p-values).}

\item{K0}{- vector of search range starts (from the k0th smallest p-value).}

\item{K1}{- vector of search range ends (at the k1th smallest p-value).}

\item{S}{- vector of the phi-divergence test parameters.}

\item{onesided}{- TRUE if the input p-values are one-sided.}
}
\description{
calculate the right-tail probability of omnibus phi-divergence statistics under general correlation matrix.
}
\examples{
M = matrix(0.3,10,10) + diag(1-0.3, 10)
test.phi.omni(runif(10), M=M, K0=rep(1,4), K1=rep(5,4), S=c(-1,0,1,2))
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal Signal-Detection Methods In Finite Cases", submitted.
}
