% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.phi.R
\name{stat.phi}
\alias{stat.phi}
\title{Construct phi-divergence statitics.}
\usage{
stat.phi(p, s, beta)
}
\arguments{
\item{p}{- vector of input p-values.}

\item{s}{- phi-divergence parameter. s = 2 is the higher criticism statitic.s = 1 is the Berk and Jones statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}
}
\value{
value - phi-divergence statistic constructed from a vector of p-values.

location - the order of the p-values to obtain phi-divergence statistic.

stat - vector of marginal phi-divergence statistics.
}
\description{
Construct phi-divergence statitics.
}
\details{
Let \eqn{p_{(i)}}, \eqn{i = 1,...,n} be a sequence of ordered p-values, the phi-divergence statistic
\deqn{PHI = \sqrt{2n}/(s - s^2) \max_{1 \leq i\leq \lfloor \beta n \rfloor} (-1)^j \sqrt{1 - (i/n)^s  (p_{(i)})^s - (1-i/n)^{(1-s)} * (1-p_{(i)})^{(1-s)}}}
and when \eqn{p_{(i)} > i/n}, \eqn{j = 1}, otherwise \eqn{j = 0}.
}
\examples{
stat.phi(runif(10), 2, 0.5)
#When the input are statistics#
stat.test = rnorm(20)
p.test = 1 - pnorm(stat.test)
stat.phi(p.test, s = 0.5, beta = 0.5)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Jager, Leah; Wellner, Jon A. "Goodness-of-fit tests via phi-divergences". Annals of Statistics 35 (2007).
}

