% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{heatmap_network}
\alias{heatmap_network}
\title{Plot heatmap representation of a network}
\usage{
heatmap_network(
  network,
  main = NULL,
  col = colorRampPalette(gray.colors(8, 0.1, 1))(50),
  ...
)
}
\arguments{
\item{network}{Either a network object or association matrix of the network.}

\item{main}{A string containing the title for the graph.}

\item{col}{Color palatte used for heatmap. See \code{link[stats]{heatmap}}
for details.}

\item{...}{Additional arguments passed to \code{link[stats]{heatmap}}.}
}
\value{
The matrix used to create the heatmap.
}
\description{
This function plots the given network as a heatmap to visualize its
connections. If the network is weighted, then the heatmap will use greyscale
colors to represent connection strengths; black squares correspond to the
strongest connections, while lighter color squares are weaker connections.
}
\examples{
set.seed(12345)
nw <- random_network(10)
nw <- set_node_names(nw, paste("node", 1:10, sep = "_"))
heatmap_network(nw, "Unweighted Network")
nw <- gen_partial_correlations(nw)
heatmap_network(nw, "Weighted Network")
}
