% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{get_summary_for_node}
\alias{get_summary_for_node}
\title{Get summary for a node in the network.}
\usage{
get_summary_for_node(node, network)
}
\arguments{
\item{node}{The node to summarize. Can be a character string 
corresponding to a name of a node in the network, or an integer value from 
1 to p corresponding to the index of a node.}

\item{network}{A network object.}
}
\value{
A list containing summary information for the node; this includes 
a vector of indicies to other nodes in the network it is connected to, and 
a vector of incidices to modules that contain the node.
}
\description{
Get summary for a node in the network.
}
\examples{
set.seed(12345)
nw <- random_network(100)
get_summary_for_node(1, nw)
# Node 1 is contained in modules 1 and 2, and it is connected to nodes 
# 2, 4, 11, 13, 23, and 29.
}
