% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensusR.R
\name{sensus.read.json}
\alias{sensus.read.json}
\title{Read JSON-formatted Sensus data.}
\usage{
sensus.read.json(data.path, is.directory = TRUE, recursive = TRUE,
  convert.to.local.timezone = TRUE, local.timezone = Sys.timezone())
}
\arguments{
\item{data.path}{Path to Sensus JSON data (either a file or a directory).}

\item{is.directory}{Whether or not the path is a directory.}

\item{recursive}{Whether or not to read files recursively from directory indicated by path.}

\item{convert.to.local.timezone}{Whether or not to convert timestamps to the local timezone.}

\item{local.timezone}{If converting timestamps to local timesonze, the local timezone to use.}
}
\value{
All data, listed by type.
}
\description{
Read JSON-formatted Sensus data.
}
\examples{
data.path = system.file("extdata", "example_data", package="SensusR")
data = sensus.read.json(data.path)
}
