% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.dictionary.R
\name{append.dictionary}
\alias{append.dictionary}
\title{Appendix Dictionary}
\usage{
append.dictionary(..., dictionary.name = "appendix",
  save.location = c("envir", "package", "choose", "path"), path = NULL,
  textcleaner = FALSE)
}
\arguments{
\item{...}{Character vector.
A vector of words to create or add to a dictionary}

\item{dictionary.name}{Character.
Name of dictionary to create or add words to.
Defaults to \code{"appendix"}.
Input a name to create or add to an existing dictionary.
This function with automatically name files with the \code{"*.dictionary.rds"} suffix}

\item{save.location}{Character.
A choice for where to store appendix dictionary.
Defaults to \code{"envir"}.

\itemize{

\item{\code{"envir"}:}
{Returns dictionary as a vector object to \code{R}'s global environment}

\item{\code{"package"}:}
{Saves dictionary to the package
(see \code{system.file("data",package="SemNetDictionaries")} for location).
Note that this dictionary will be deleted when \code{\link{SemNetDictionaries}}
is updated.}

\item{\code{"choose"}:}
{User chooses a directory for more permanent storage. This will
allow you to use this dictionary in the future}

\item{\code{"path"}:}
{User specifies a path to a directory if it is already known. This
will allow direct updates to the directory and bypass the prompts in
the save/update menus. This will also allow you to use
this dictionary in the future}

}}

\item{path}{Character.
A path to an existing directory.
Only necessary for \code{save.location = "path"}}

\item{textcleaner}{Boolean.
Argument for skipping asking to save the dictionary twice.
Defaults to \code{FALSE}.
If \code{TRUE}, then asking to save the dictionary will be skipped.}
}
\description{
A function designed to create post-hoc dictionaries in the
\code{\link{SemNetDictionaries}} package. This allows for new semantic categories or word lists
to be saved for future use (i.e., your own personal dictionary).
Dictionaries created using this function can either be saved as an R object to your global
environment or as a .rds file on your current computer. Open-source community-derived
dictionaries can be uploaded to and downloaded from
\href{https://github.com/AlexChristensen/SemNetDictionaries}{https://github.com/AlexChristensen/SemNetDictionaries}
}
\details{
Appendix dictionaries are useful for storing spelling
definitions that are not available in the \code{\link{SemNetDictionaries}}
package. This function enables the storage of personalized dictionaries,
which can be used in combination with other dictionaries to facilitate
the cleaning of text data.

Dictionaries are either stored in \code{R}'s global environment,
where they will be deleted once \code{R} is closed (unless you save them),
or in a directory you choose. A menu will pop-up asking whether you would like to
save or update your dictionary.
You have two options:

\itemize{

\item{\code{Yes} (or \code{1}):}
{Gives this function permission to
save (or update) your dictionary to a chosen directory.
If \code{save.location = "envir"}, your file will
be deleted after closing \code{R}}

\item{\code{No} (or \code{2}):}
{Does NOT give this function permission to save
your dictionary to your computer. \code{save.location = "envir"} will
always return your dictionary as a vector object to \code{R}'s
global environment}

}

To save your dictionary file, you can either:

\itemize{

\item{Manually save:}
{Use \link{saveRDS} and save using the \code{"*.dictionary"} suffix}

\item{\code{save.location = "choose"}:}
{A file explorer menu will pop-up and a directory can be manually selected}

\item{\code{save.location = "path"}:}
{The file will automatically be saved to the directory you provide}

}

Note that \code{save.location = "choose"} and \code{save.location = "path"} will
automatically update your dictionary if there is a file with the same name enter
into the \code{dictionary.name} argument.

To find where your dictionaries are stored, use the
\code{\link[SemNetDictionaries]{find.dictionaries}} function.
These dictionaries are only stored on
your private computer and must either be publicly shared or
transferred to other computers in order to use them elsewhere.
If you would like to share a dictionary for others to use, then please submit
a pull request or post an issue with your dictionary on my GitHub:
\href{https://github.com/AlexChristensen/SemNetDictionaries}{AlexChristensen/SemNetDictionaries}.
}
\examples{
# Create a dictionary
new.dictionary <- append.dictionary(c("words","are","fun"), save.location = "envir")

}
\seealso{
\code{\link{find.dictionaries}} to find where dictionaries are stored,
\code{\link{dictionaries}} to identify dictionaries in
\code{\link{SemNetDictionaries}}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
