% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct.changes.R
\name{correct.changes}
\alias{correct.changes}
\title{Correct Changes from \code{\link[SemNetCleaner]{textcleaner}}}
\usage{
correct.changes(textcleaner.obj)
}
\arguments{
\item{textcleaner.obj}{Object from \code{\link[SemNetCleaner]{textcleaner}}}
}
\value{
This function returns the corrected lists from \code{\link[SemNetCleaner]{textcleaner}}s:

\item{binary}{A matrix of responses where each row represents a participant
and each column represents a unique response. A response that a participant has provided is a '\code{1}'
and a response that a participant has not provided is a '\code{0}'}

\item{responses}{A list containing two objects:

\itemize{

\item{clean}
{A response matrix that has been spell-checked and de-pluralized with duplicates removed.
This can be used as a final dataset for analyses (e.g., fluency of responses)}

\item{original}
{The original response matrix that has had white spaces before and
after words response. Also converts all upper-case letters to lower case}

}

}

\item{spellcheck}{A list containing three objects:

\itemize{

\item{\code{full}}
{All responses regardless of spell-checking changes}

\item{\code{auto}}
{Only the incorrect responses that were changed during spell-check}

\item{\code{changes}}
{Only the changes made within the function \code{\link[SemNetCleaner]{correct.changes}}}

}

}

\item{removed}{A list containing two objects: 

\itemize{

\item{\code{rows}}
{Identifies removed participants by their row (or column) location in the original data file}

\item{\code{ids}}
{Identifies removed participants by their ID (see argument \code{data})}

}

}

\item{partChanges}{A list where each participant is a list index with each
response that was been changed. Participants are identified by their ID (see argument \code{data}).
This can be used to replicate the cleaning process and to keep track of changes more generally.
Participants with \code{NA} did not have any changes from their original data
and participants with missing data are removed (see \code{removed$ids})}
}
\description{
A function that corrects changes that were made
automatically by \code{\link[SemNetCleaner]{textcleaner}}
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1:3)]

if(interactive())
{
    #Full test
    clean <- textcleaner(open.animals[,-c(1,2)], partBY = "row", dictionary = "animals")
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
