% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semnetmeas.R
\name{semnetmeas}
\alias{semnetmeas}
\title{Semantic Network Measures}
\usage{
semnetmeas(A, iter, weighted = FALSE, swm = "rand")
}
\arguments{
\item{A}{An adjacency matrix of network A}

\item{iter}{Number of iterations for the small-worldness measure}

\item{weighted}{Should weighted measures be computed?
Defaults to FALSE.
Set to TRUE for weighted measures}

\item{swm}{Method for computing small-worldness.
Defaults to "rand".
See \link[NetworkToolbox]{smallworldness} for other options}
}
\value{
Returns a values for ASPL, CC, Q, and S
}
\description{
Computes the average shortest path length (ASPL),
clustering coefficient(CC),
modularity (Q),
small-worldness (S; defaults to "rand"),
and mean network strength (MNS)
}
\examples{
lowO <- subset(NetworkToolbox::animals, Group==1)[-1]

cosL <- cosine(lowO)

A <- NetworkToolbox::TMFG(cosL)$A

globmeas <- semnetmeas(A)
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
