% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFitting.R
\name{fitSccsModel}
\alias{fitSccsModel}
\title{Fit the SCCS model}
\usage{
fitSccsModel(sccsIntervalData, fitSccsModelArgs)
}
\arguments{
\item{sccsIntervalData}{An object of type \link{SccsIntervalData} as created using the
\link{createSccsIntervalData} function.}

\item{fitSccsModelArgs}{An object of type \code{FitSccsModelArgs} as created by the \code{createFitSccsModelArgs()} function.}
}
\value{
An object of type \code{SccsModel}. Generic functions \code{print}, \code{coef}, and
\code{confint} are available.
}
\description{
Fit the SCCS model
}
\details{
Fits the SCCS model as a conditional Poisson regression. When allowed, coefficients for some or all
covariates can be regularized.

Likelihood profiling is only done for variables for which \code{profileLikelihood} is set to \code{TRUE} when
calling \code{\link[=createEraCovariateSettings]{createEraCovariateSettings()}}. Either specify the \code{profileGrid} for a completely user-
defined grid, or \code{profileBounds} for an adaptive grid. Both should be defined on the log IRR scale.
When both \code{profileGrid} and \code{profileGrid} are \code{NULL} likelihood profiling is disabled.
}
\references{
Suchard, M.A., Simpson, S.E., Zorych, I., Ryan, P., and Madigan, D. (2013). Massive parallelization
of serial inference algorithms for complex generalized linear models. ACM Transactions on Modeling
and Computer Simulation 23, 10
}
