% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combine}
\alias{combine}
\title{Combine two data tables}
\usage{
combine(dt1, dt2, ...)
}
\arguments{
\item{dt1}{first data table}

\item{dt2}{second data table}

\item{...}{passed on to data.table::merge}
}
\value{
The merged data table
}
\description{
Function for combining two data tables, e.g. with predictions and observations.
This is a user-friendly wrapper for \code{\link[data.table]{merge}}. It guesses the columns to merge by (the dimension variables
contained in both data tables) and adds some warnings when merges are attempted that are likely not correctly specified by the user.
}
\examples{
# merge ECMWF-forecasts and CHIRPS observations:
dt = ecmwf_monthly[month == 11]
setnames(dt,'prec','forecast') # forecasts and observations both have a column 'prec'
dt_new = combine(dt,chirps_monthly)

}
