% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelstoch_dir.R
\name{modelstoch_dir}
\alias{modelstoch_dir}
\title{Chance Constrained Directional Models with Stochastic Directions}
\usage{
modelstoch_dir(datadea,
            alpha = 0.05,
            dmu_eval = NULL,
            dmu_ref = NULL,
            d_input = 1,
            d_output = 1,
            rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
            L = 1,
            U = 1,
            solver = c("alabama", "cccp", "cccp2", "slsqp"),
            give_X = TRUE,
            n_attempts_max = 5,
            maxslack = FALSE,
            weight_slack_i = 1,
            weight_slack_o = 1,
            compute_target = TRUE,
            returnqp = FALSE,
            silent_ud = FALSE,
            ...)
}
\arguments{
\item{datadea}{The data of class \code{deadata_stoch}, including \code{n} DMUs,
and the expected values of \code{m} inputs and \code{s} outputs.}

\item{alpha}{A value for parameter alpha.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation
reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{d_input}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the input orientation parameters.
If \code{d_input} == 1 (default) and \code{dir_output} == 0, it is equivalent
to input oriented (\code{beta} = 1 - \code{efficiency}).}

\item{d_output}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the output orientation parameters.
If \code{d_input} == 0 and \code{d_output} == 1 (default), it is equivalent
to output oriented (\code{beta} = \code{efficiency} - 1).}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{solver}{Character string with the name of the solver used by function \code{solvecop}
from package \code{optiSolve}.}

\item{give_X}{Logical. If it is \code{TRUE}, it uses an initial vector (given by
the evaluated DMU) for the solver, except for "cccp". If it is \code{FALSE}, the initial vector is given
internally by the solver and it is usually randomly generated.}

\item{n_attempts_max}{A value with the maximum number of attempts if the solver
does not converge. Each attempt uses a different initial vector.}

\item{maxslack}{Logical. If it is \code{TRUE}, it computes the max slack solution.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the weights of the input slacks
for the max slack solution.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x \code{ne}
(where \code{ne} is the length of \code{dmu_eval}) with the weights of the output
slacks for the max slack solution.}

\item{compute_target}{Logical. If it is \code{TRUE}, it computes targets of the
max slack solution.}

\item{returnqp}{Logical. If it is \code{TRUE}, it returns the quadratic problems
(objective function and constraints) of stage 1.}

\item{silent_ud}{Logical, to avoid warnings related with undesirable variables.}

\item{...}{Other parameters, like the initial vector \code{X}, to be passed to the solver.}
}
\value{
A list with the results for the evaluated DMUs and other parameters
for reproducibility.
}
\description{
It solves chance constrained directional models with stochastic directions,
under constant, variable, non-increasing, non-decreasing or generalized returns to
scale. Inputs and outputs must follow a multivariate normal distribution.
By default, models are solved in a two-stage process (slacks are maximized).

We consider \eqn{\mathcal{D}=\left\{ \textrm{DMU}_1, \ldots ,\textrm{DMU}_n \right\} }
a set of \eqn{n} DMUs with \eqn{m} stochastic inputs and \eqn{s} stochastic outputs.
Matrices \eqn{\tilde{X}=(\tilde{x}_{ij})} and \eqn{\tilde{Y}=(\tilde{y}_{rj})}
are the input and output data matrices, respectively, where \eqn{\tilde{x}_{ij}}
and \eqn{\tilde{y}_{rj}} represent the \eqn{i}-th input and \eqn{r}-th output
of the \eqn{j}-th DMU. Moreover, we denote by \eqn{X=(x_{ij})} and \eqn{Y=(y_{rj})}
their expected values. In general, we denote vectors by bold-face letters and
they are considered as column vectors unless otherwise stated. The \eqn{0}-vector
is denoted by \eqn{\bm{0}} and the context determines its dimension.

Given \eqn{0<\alpha <1}, the first stage program for \eqn{\text{DMU}_o} with
constant returns to scale is given by
\deqn{\max \limits_{\beta, \bm{\lambda}}\quad \beta}
\deqn{\text{s.t.}\quad P\left\{ \left( \Theta ^-(\beta )\tilde{\mathbf{x}}_o-
\tilde{X}\bm{\lambda}\right) _i\geq 0\right\} \geq 1-\alpha,\quad
i=1,\ldots ,m,}
\deqn{P\left\{ \left( \tilde{Y}\bm{\lambda}-\Theta ^+(\beta )
\tilde{\mathbf{y}}_{o}\right) _r\geq 0\right\} \geq 1-\alpha,\quad
r=1,\ldots ,s,}
\deqn{\bm{\lambda}\geq \mathbf{0},}
where \eqn{\bm{\lambda}=(\lambda_1,\ldots,\lambda_n)^\top}, \eqn{\tilde{\mathbf{x}}_o
=(\tilde{x}_{1o},\ldots,\tilde{x}_{mo})^\top} and \eqn{\tilde{\mathbf{y}}_o=
(\tilde{y}_{1o},\ldots,\tilde{y}_{so})^\top} are column vectors,
\eqn{\Theta ^-(\beta )=I_m-\beta D^-}, \eqn{\Theta ^+(\beta )=I_s+\beta
D^+} (with \eqn{I_m,I_s} identity matrices), and \eqn{D^-=\mathrm{diag}(d^-_1,
\ldots ,d^-_m)}, \eqn{D^+=\mathrm{diag}(d^+_1,\ldots ,d^+_s)} are diagonal matrices
with orientation parameters \eqn{d^-_1,\ldots ,d^-_m,  d^+_1,\ldots ,d^+_s \geq 0}.
Different returns to scale can be easily considered by adding the corresponding
constraints: \eqn{\mathbf{e}\bm{\lambda}=1} (VRS), \eqn{0\leq \mathbf{e}\bm{\lambda}
\leq 1} (NIRS), \eqn{\mathbf{e}\bm{\lambda}\geq 1} (NDRS) or \eqn{L\leq \mathbf{e}
\bm{\lambda}\leq U} (GRS), with \eqn{0\leq L\leq 1} and \eqn{U\geq 1}, where
\eqn{\mathbf{e}=(1,\ldots ,1)} is a row vector.

The corresponding second stage program is given by
\deqn{\max \limits_{\bm{\lambda},\mathbf{s}^-,\mathbf{s}^+}\quad \mathbf{w}^-
\mathbf{s}^-+\mathbf{w}^+\mathbf{s}^+}
\deqn{\text{s.t.}\quad P\left\{ \left( \Theta ^-(\beta ^*)\tilde{\mathbf{x}}_o-
\tilde{X}\bm{\lambda}-\mathbf{s}^-\right) _i\geq 0\right\} = 1-\alpha,\quad
i=1,\ldots ,m,}
\deqn{P\left\{ \left( \tilde{Y}\bm{\lambda}-\Theta ^+(\beta ^*)
\tilde{\mathbf{y}}_{o}-\mathbf{s}^+\right) _r\geq 0\right\} = 1-\alpha,\quad
r=1,\ldots ,s,}
\deqn{\bm{\lambda}\geq \mathbf{0},\,\, \mathbf{s}^-\geq \mathbf{0},\,\,
\mathbf{s}^+\geq \mathbf{0},}
where \eqn{\beta ^*} is the optimal objective function of the first stage
program, \eqn{\mathbf{s}^-,\mathbf{s}^+} are column vectors with the slacks,
and \eqn{\mathbf{w}^-,\mathbf{w}^+} are positive row vectors with the weights
for the slacks.

The deterministic equivalents for a multivariate normal distribution of inputs/outputs
are given by
\deqn{\max \limits_{\beta, \bm{\lambda}} \quad \beta}
\deqn{\text{s.t.} \quad X\bm{\lambda}-\Phi ^{-1}(\alpha)\bm{\sigma} ^-(\beta ,
\bm{\lambda}) \leq \Theta ^-(\beta )\mathbf{x}_o,}
\deqn{Y\bm{\lambda}+\Phi ^{-1}(\alpha)\bm{\sigma} ^+(\beta ,\bm{\lambda})
\geq \Theta ^+(\beta )\mathbf{y}_o,}
\deqn{\bm{\lambda}\geq \mathbf{0},}
and for the second stage,
\deqn{\max \limits_{\bm{\lambda},\mathbf{s}^-,\mathbf{s}^+} \quad \mathbf{w}^-
\mathbf{s}^-+\mathbf{w}^+\mathbf{s}^+}
\deqn{\text{s.t.} \quad X\bm{\lambda}+\mathbf{s}^--\Phi ^{-1}(\alpha)
\bm{\sigma} ^-(\beta ^*,\bm{\lambda}) =\Theta ^-(\beta ^*)\mathbf{x}_o,}
\deqn{Y\bm{\lambda}-\mathbf{s}^++\Phi ^{-1}(\alpha)\bm{\sigma} ^+(\beta ^*,
\bm{\lambda}) = \Theta ^+(\beta ^*)\mathbf{y}_{o},}
\deqn{\bm{\lambda}\geq \mathbf{0},\,\, \mathbf{s}^-\geq \mathbf{0},\,\,
\mathbf{s}^+\geq \mathbf{0},}
where \eqn{\Phi } is the standard normal distribution, and
\deqn{\displaystyle \left( \sigma ^-_i\left( \beta, \bm{\lambda}\right)\right) ^2 =
\sum _{j,q=1}^n\lambda _j\lambda _q\mathrm{Cov}(\tilde{x}_{ij},\tilde{x}_{iq})-
2(1-\beta d^-_i)\sum _{j=1}^n\lambda _j\mathrm{Cov}(\tilde{x}_{ij},\tilde{x}_{io})}
\deqn{+(1-\beta d^-_i)^2\mathrm{Var}(\tilde{x}_{io}),\quad i=1,\ldots ,m,}
\deqn{\displaystyle \left( \sigma ^+_r\left( \beta, \bm{\lambda}\right)\right) ^2 =
\sum _{j,q=1}^n\lambda _j\lambda _q\mathrm{Cov}(\tilde{y}_{rj},\tilde{y}_{rq})-
2(1+\beta d^+_r)\sum _{j=1}^n\lambda _j\mathrm{Cov}(\tilde{y}_{rj},\tilde{y}_{ro})}
\deqn{+(1+\beta d^+_r)^2\mathrm{Var}(\tilde{y}_{ro}),\quad r=1,\ldots ,s.}
}
\examples{
\donttest{
# Example 1.
library(deaR)
data("Coll_Blasco_2006")
ni <- 2 # number of inputs
no <- 2 # number of outputs
data_example <- make_deadata(datadea = Coll_Blasco_2006,
                             ni = ni,
                             no = no)
nd <- length(data_example$dmunames) # number of DMUs
var_input <- matrix(1, nrow = ni, ncol = nd)
var_output <- matrix(1, nrow = no, ncol = nd)
data_stoch <- make_deadata_stoch(datadea = data_example,
                                 var_input = var_input,
                                 var_output = var_output)
Collstochdir <- modelstoch_dir(data_stoch)
}

}
\references{
Bolós, V.J.; Benítez, R.; Coll-Serrano, V. (2024). “Chance constrained directional
models in stochastic data envelopment analysis", Operations Research Perspectives, 12, 100307..
\doi{10.1016/j.orp.2024.100307}
}
\author{
\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

University of Valencia (Spain)
}
