% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/swmpr_organize.R
\name{qaqcchk}
\alias{qaqcchk}
\alias{qaqcchk.swmpr}
\title{Summary of QAQC flags in SWMP data}
\usage{
qaqcchk(swmpr_in)

\method{qaqcchk}{swmpr}(swmpr_in)
}
\arguments{
\item{swmpr_in}{input swmpr object}
}
\value{
Returns a \code{\link[base]{data.frame}} with columns for swmpr parameters and row counts indicating the number of observations in each parameter assigned to a flag value.
}
\description{
Summary of the number of observations with a given QAQC flag for each parameter column of a swmpr object
}
\details{
Viewing the number of observations for each parameter that are assigned to a QAQC flag may be useful for deciding how to process the data qith qaqc. The \code{qaqcchk} function can be used to view this information. Consult the online documentation for a description of each QAQC flag: \url{http://cdmo.baruch.sc.edu/data/qaqc.cfm}
}
\examples{
## get data
data(apadbwq)
dat <- apadbwq

## view the number observations in each QAQC flag
qaqcchk(dat)
}
\seealso{
\code{\link{qaqc}}
}

