% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsb_map_chimp_full.R
\docType{data}
\name{dsb_map_chimp_full}
\alias{dsb_map_chimp_full}
\title{Data of the DsbMap for chimpanzees}
\format{The data set contains 64078 rows and 3 columns. We provide information on the columns (column nr, column name) hereafter:
\describe{
\item{1, chrom}{The chromosome under study}
\item{2, start}{Start coordinates of the hotspot}
\item{3, end}{End coordinates of the hotspot}
}}
\usage{
data (dsb_map_chimp_full)
}
\description{
A dataset containing all translated PRDM9-A type hotspots of Pratto et al. (2014) for chimpanzees.
The translation was performed using liftOver of the UCSC Genome Browser from the human genome (hg19) to the chimpanzees genome (panTro5).
}
\references{
Heissl, A., et al. (2018) Length asymmetry and heterozygosity strongly influences the evolution of poly-A microsatellites at meiotic recombination hotspots. doi: https://doi.org/10.1101/431841

Pratto, F., et al. (2014). Recombination initiation maps of individual human genomes. Science, 346(6211).

Kuhn RM, et al. (2013) The UCSC genome browser and associated tools, Brief. Bioinform., 14, 144-161.
}
\seealso{
\code{\link{STR_analysis}}, \code{\link{STR_detection}}
}
\keyword{datasets}
