% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/release-S3.R
\name{plot.STMr_release}
\alias{plot.STMr_release}
\title{Plotting of the Release}
\usage{
\method{plot}{STMr_release}(x, font_size = 14, load_1RM_agg_func = max, ...)
}
\arguments{
\item{x}{\code{STMr_release} object}

\item{font_size}{Numeric. Default is 14}

\item{load_1RM_agg_func}{Function to aggregate step \code{load_1RM} from
multiple sets. Default is \code{\link[base]{max}}}

\item{...}{Forwarded to \code{\link[ggfittext]{geom_bar_text}} and
\code{\link[ggfittext]{geom_fit_text}} functions. Can be used to se the highest
labels size, for example, using \code{size=5}. See documentation for these two
packages for more info}
}
\value{
\code{ggplot2} object
}
\description{
Function for creating \code{ggplot2} plot of the Release \code{STMr_release} object
}
\examples{
scheme1 <- scheme_step(vertical_planning = vertical_constant)
scheme2 <- scheme_step(vertical_planning = vertical_linear)
scheme3 <- scheme_step(vertical_planning = vertical_undulating)

release_df <- release(
  scheme1, scheme2, scheme3,
  additive_1RM_adjustment = 2.5
)

plot(release_df)
}
