% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunction.R
\name{STSIdentifyCandidateSTMotifs}
\alias{STSIdentifyCandidateSTMotifs}
\title{Generate candidates}
\usage{
STSIdentifyCandidateSTMotifs(data, tslice, sslice, alpha = 7,
  window_size = 3)
}
\arguments{
\item{data}{Dataset containing numeric values}

\item{tslice}{"Time slice" Number of row in each block}

\item{sslice}{"Space slice" Number of column in each block}

\item{alpha}{Number of letter to do the encode}

\item{window_size}{Length of motifs}
}
\value{
List [Motifs, Nrows, Ncols, Rectangles, Blocks, Saxblocks] cantining all information about the blocks : number of blocks in rows and columns, values of each block (numeric and encoded values) and information about frequent motifs in blocks.

Motifs : Contain for each block the Subs : data frame containing all the subsequences in original data frame, Subs.SAX : data frame containing all the subsequences in SAX representations, Motif.raw : a list showing the motifs discovered in the original data frame, Morif.SAX : a list showing the motifs discovered in SAX representations and Indices : a list showing the starting positions of subsequences for each motif discovered.

Nrows : Numeric value giving the number of row which delimited the blocks created

Ncols : Numeric value giving the number of column which delimited the blocks created

Rectangles : For each block gives information about the position of the block into the orginal dataset

Blocks : Contains the values of each blocks and the nrows and ncols

Saxblocks : Contains the values encoded bay SAX of each blocks and the nrows and ncols
}
\description{
Find frequent motifs in a dataset
}
\note{
To see all the stages of the generation of candidates : \href{../inst/doc/generation-of-candidates.html}{Generation of candidates}
}
\examples{
#Generation of candidates
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)
}
