\name{isi}
\alias{isi}
\title{ Get Lagged Inter Spike Intervals (ISIs) From Data Frames
  Generated by mkGLMdf }
\description{
  A utility function to create a vector containing the ith preceding 
  inter spike interval (isi) at a given time.
}
\usage{
isi(dataFrame, lag = 1)
}
\arguments{
  \item{dataFrame}{a \code{\link{data.frame}} typically generated by
    \code{\link{mkGLMdf}}. Should at least contain an \code{event}
     and a \code{time} variable.}
  \item{lag}{a strictly positive integer. Set to 1 if the previous isi
    is required, to 2 is the isi preceding the last one is required, etc...}
}
\details{
  Look at the (short) source file for details.
}
\value{
  A \code{numeric} vector with the value of the \code{lag}th isi
  preceding the time of the corresponding bin center.
}
\author{Christophe Pouzat \email{christophe.pouzat@gmail.com} }
\note{
  Before plugging the result into \code{\link[gss]{gssanova}}, do not forget
  to remove the \code{NA} elements (see the example).
}
\seealso{
  \code{\link{mkGLMdf}},
  \code{\link[gss]{gssanova}},
  \code{\link{\%tt\%}}
  
}
\examples{
\dontrun{
## load e060517spont data set
data(e060517spont)
## make a data frame using a 2 ms bin width
e060517spontDF <- mkGLMdf(e060517spont,0.002,0,60)
## Keep data relevant to neuron 1
e060517spontDFn1 <- e060517spontDF[e060517spontDF$neuron == "1",]
## get the isi at lag 1 and 2
e060517spontDFn1$isi1 <- isi(e060517spontDFn1,lag=1)
e060517spontDFn1$isi2 <- isi(e060517spontDFn1,lag=2)
## keep only defined elements
e060517spontDFn1 <- e060517spontDFn1[!is.na(e060517spontDFn1$isi2),]
## split the data set into an "early" and a "late" part
e060517spontDFn1e <- e060517spontDFn1[e060517spontDFn1$time <= 30,]
e060517spontDFn1l <- e060517spontDFn1[e060517spontDFn1$time > 30,]
## Fit the late part
e060517spontDFn1lGF <- gssanova(event ~ lN.1*isi1+isi2, data=e060517spontDFn1l, family="binomial", seed=20061001)
## Time transform the early part and perform goodness of fit tests
e060517spont.n1e.tt <- e060517spontDFn1lGF \%tt\% e060517spontDFn1e
e060517spont.n1e.tt
summary(e060517spont.n1e.tt)
plot(summary(e060517spont.n1e.tt))
}
}
\keyword{ts}
\keyword{survival}
\keyword{htest}
