\name{gampsth}
\alias{gampsth}
\alias{print.gampsth}
\alias{summary.gampsth}
\alias{plot.gampsth}
\title{Smooth Peri Stimulus Time Histogram Related Functions and
  Methods: The Penalized Regression Spline Approach}
\description{
  Function \code{gampsth} computes a smooth psth, while method
  \code{print.gampsth} prints and \code{summary.gampsth} summarises the
  \code{gamObject} contained in the returned \code{gampsth} object and
  \code{plot.gampsth} plots it. 
}
\usage{
gampsth(repeatedTrain, binSize = 0.025, k = 100,
      bs = "tp", plot = TRUE,...)
\method{print}{gampsth}(x, ...)
\method{summary}{gampsth}(object, ...)
\method{plot}{gampsth}(x, stimTimeCourse = NULL, colStim = "grey80",
           colCI = NULL, xlab, ylab, main, xlim, ylim,
           lwd = 2, col = 1, ...)

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{repeatedTrain}{a \code{repeatedTrain} object or a list which can be
    coerced to such an object.}
  \item{binSize}{the bin size (in s) used to generate the observations on which
  the gam fit will be performed. See details below.}
  \item{k}{the dimension of the basis used to represent the smooth
    psth. See \code{\link[mgcv]{s}}.}
  \item{bs}{the type of splines used. See \code{\link[mgcv]{s}}.}
  \item{plot}{corresponding argument of \code{\link{hist}}. Should a
    plot be generated or not?}
  \item{object}{a \code{gampsth} object.}
  \item{x}{a \code{gampsth} object.}
  \item{stimTimeCourse}{\code{NULL} (default) or a two elements vector
    specifying the time boundaries (in s) of a stimulus presentation.}
  \item{colStim}{the background color used for the stimulus.}
  \item{colCI}{if not \code{NULL} (default) a confidence band is
    plotted with the specified color; two dashed lines are plotted otherwise.}
  \item{xlim}{a numeric (default value supplied). See
    \code{\link{plot}}.}
  \item{ylim}{a numeric (default value supplied). See \code{\link{plot}}.}
  \item{xlab}{a character (default value supplied). See \code{\link{plot}}.}
  \item{ylab}{a character (default value supplied). See \code{\link{plot}}.}
  \item{main}{a character (default value supplied). See \code{\link{plot}}.}
  \item{lwd}{line width used to plot the estimated density. See \code{\link{plot}}.}
  \item{col}{color used to plot the estimated density. See \code{\link{plot}}.}
  \item{\dots}{in \code{gampsth}, if \code{plot} is set to \code{TRUE}
    then the \dots are passed to \code{plot.gampsth}. In
    \code{plot.gampsth} they are passed to \code{\link{plot}} which is
    called internally. They are not used otherwise.}
}
\details{
  For \code{gampsth}, the raw data contained in \code{repeatedTrain} are
  pre-processed with \code{\link{hist}} using a bin size given by
  argument \code{binSize}. This \code{binSize} should be small "enough". That is, the
  rate of the aggregated train created by collapsing the spike times of
  the different trials onto a single "pseudo" spike train, should not
  change too much on the scale of \code{binSize} (see Ventura et al
  (2002) Sec. 4.2 p8 for more details). 
}
\value{
  When \code{plot} is set to \code{FALSE} in \code{gampsth}, a list of
  class \code{gampsth} is returned and no plot
  is generated. This list has the following components:
  \item{freq }{a vector containing the instantaneous firing rate in the
    middle of the "thin" bins used for preprocessing.}
  \item{ciUp }{a vector with the upper limit of a pointwise 95\% confidence interval. Check \code{\link[mgcv]{predict.gam}} for details.}
  \item{ciLow }{a vector with the lower limit of a pointwise 95\% confidence interval.}
  \item{breaks }{a vector with 2 elements the ealiest and the latest spike in \code{repeatedTrain}.}
  \item{mids }{a numeric vector with the mid points of
    the bins.}
  \item{counts }{a vector with the actual number of spikes in each bin.}
  \item{nbTrials }{the number of trials in \code{repeatedTrain}.}
  \item{lambdaFct }{a function of a single time argument returning the
    estimated intensity (or instantaneous rate) at its argument.}
  \item{LambdaFct }{a function of a single time argument returning the
    integrale of estimated intensity (or instantaneous rate) at its
    argument. That is, the integrated intensity. \code{\link{integrate}}
  is used by this function.}
  \item{call }{the matched call.}

  When \code{plot} is set to \code{TRUE} nothing is returned and a plot
  is generated as a side effect. Of course the same occurs upon calling
  \code{plot.gampsth} with a \code{gampsth} object argument.

  \code{print.gampsth} returns the result of \code{\link[mgcv]{print.gam}}
  applied to the \code{\link[mgcv]{gamObject}} generated by \code{gampsth}
  and stored in the \code{\link{environment}} of both \code{lambdaFct}
  and \code{LambdaFct}.

  \code{summary.gampsth} returns the result of \code{\link[mgcv]{summary.gam}}
  applied to the \code{\link[mgcv]{gamObject}} generated by \code{gampsth}
  and stored in the \code{\link{environment}} of both \code{lambdaFct}
  and \code{LambdaFct}.

  
}
\references{
  Ventura, V., Carta, R., Kass, R. E., Gettner, S. N. and Olson,
  C. R. (2002) Statistical analysis of temporal evolution in
  single-neuron firing rates. \emph{Biostatistics} \bold{3}: 1--20.

  Kass, R. E., Ventura, V. and Cai, C. (2003) Statistical smoothing of
  neuronal data. \emph{Network: Computation in Neural Systems}
  \bold{14}: 5--15.

  Wood S.N. (2006) \emph{Generalized Additive Models: An Introduction
    with R}. Chapman and Hall/CRC Press.
}
\author{Christophe Pouzat \email{christophe.pouzat@gmail.com} }
\note{
  Most of the components of the list returned by \code{gampsth} are not of
  direct interest for the user but they are used by, for instance,
  \code{\link{reportHTML.repeatedTrain}}. 
}
\seealso{
  \code{\link{psth}},
  \code{\link{plot.psth}},
  \code{\link[mgcv]{gam}},
  \code{\link[mgcv]{print.gam}},
  \code{\link[mgcv]{summary.gam}},
  \code{\link[mgcv]{gam.check}},
  \code{\link{reportHTML.repeatedTrain}},
}
\examples{
## Get the e070528citronellal data set into workspace
data(e070528citronellal)
## Compute gampsth without a plot for neuron 1
## using a cubic regression spline
n1CitrGAMPSTH <- gampsth(e070528citronellal[[1]],plot=FALSE,bs="cr")
## plot the result
plot(n1CitrGAMPSTH,stim=c(6.14,6.64),colCI=2)
## get a summary of the gam fit
summary(n1CitrGAMPSTH)
## perhaps get a more complete check wit gam.check
n1CitrGAMPSTHgo <- gamObj(n1CitrGAMPSTH)
gam.check(n1CitrGAMPSTHgo)
## It does not look too bad
## Now take a look at the observation on which the gam
## was actually performed
plot(n1CitrGAMPSTH$mids,n1CitrGAMPSTH$counts,type="l")
## put dots at the positions of the knots
X <- n1CitrGAMPSTHgo$smooth[[1]][["xp"]]
rug(X,col=2)
## Add the estimated smooth psth after proper scaling
theBS <- diff(n1CitrGAMPSTH[["mids"]])[1]
Y <- n1CitrGAMPSTH$lambdaFct(n1CitrGAMPSTH$mids)*theBS*n1CitrGAMPSTH$nbTrials
lines(n1CitrGAMPSTH$mids,Y,col=4,lwd=2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}
\keyword{smooth}
\keyword{regression}
