% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSSA.R
\name{TSSA}
\alias{TSSA}
\title{Takeya Semantic Structure Analysis}
\usage{
TSSA(dat, m, crit = 0.93, pairwise = TRUE, sig = FALSE, exact = TRUE, alpha = 0.05,
  p.adjust.method = c("holm", "hochberg", "hommel",
                      "bonferroni", "BH", "BY", "fdr", "none"),
  digits = 3, vnames = TRUE, order = c("no", "decreasing", "increasing"),
  exclude = TRUE, output = TRUE)
}
\arguments{
\item{dat}{requires a data frame with polytomous data,
all items need to have the same numbers of response categories}

\item{m}{requires the number of item response categories}

\item{crit}{criteria for ordering coefficient}

\item{pairwise}{pairwise deletion of missing data,
if pairwise = FALSE listwise deletion if applied}

\item{sig}{if sig = TRUE, ordering will be assesed according to
ordering coefficient and statistical significance}

\item{exact}{if exact = TRUE, exact binomial test will be applied
otherwise single-sample proportion test will be applied}

\item{alpha}{significance level}

\item{p.adjust.method}{p-value correction method for multiple comparisons, see: ?p.adjust (default = holm)}

\item{digits}{integer indicating the number of decimal places to be used}

\item{vnames}{use variable names for labeling?}

\item{order}{sort by item mean of j and k?}

\item{exclude}{exclude paths with no relationship?}

\item{output}{print result table?}
}
\value{
Returns an object of class \code{tssa}, to be used for the \code{seqtable} function. The object is a list with
following entries: 'dat' (data frame), 'call" (function call), 'args' (specification of arguments),
'time' (time of analysis), 'R' (R version), 'package' (package version), and 'restab' (result table).
The 'restab' entry has following entries:
\tabular{ll}{
   \code{j}       	\tab item j \cr
   \code{k}     		\tab item k \cr
   \code{n}				\tab sample size \cr
   \code{j.mean}	  \tab mean of item j \cr
   \code{j.sd}     \tab standard devication of item j \cr
   \code{k.mean}   \tab mean of item k \cr
   \code{k.sd}     \tab standard devication of item k \cr
   \code{c.jk}	   	\tab ordering coefficient j -> k \cr
   \code{p.jk}     \tab p-value j -> k  (available if \code{sig = TRUE}) \cr
   \code{sig.jk}   \tab statistical significane p-value j -> k  (0 = no / 1 = yes; available if sig = TRUE) \cr
   \code{c.kj}     \tab ordering coefficient k -> j \cr
   \code{p.kj}     \tab p-value k -> j  (0 = no / 1 = yes; available if \code{sig = TRUE}) \cr
   \code{sig.kj}   \tab statistical significane p-value k -> j (available if \code{sig = TRUE}) \cr
   \code{crt.jk}   \tab ordering j -> k \cr
   \code{crt.kj}   \tab ordering k -> j \cr
   \code{order}    \tab order structure of item pairs ("=", "+","-") \cr
 }
}
\description{
This function conducts Takeya Semantic Structure Analysis (TSSA) for polytomous items based on
Takeya 1991.
}
\details{
In Takeya Semantic Structure Analysis (TSSA), a pair of items (e.g., Item1 and Item2) is judged 'sequential',
if exceptional answer patterns are less than a defined criterion. If we suppose Item1 to be the item with higher
item mean than Item2 (i.e., 'Item1 -> Item2' in the treegram), 'exceptional answer patter' means that somone
gets a lower score on Item1 and a higher score on Item2. If this kind of sequential relation is bi-directional
(i.e., not only 'Item1 -> Item2' but also 'Item2 -> Item1'), the relation of the two items is judged 'equal'.
}
\examples{
# Example data based on Takeya (1991)

# Takeya Semantic Structure Analysis
# ordering assesed according to the ordering coefficient
TSSA(exdat, m = 5)

# Takeya Semantic Structure Analysis including statistical testing
# ordering assesed according to the ordering coefficient and statistical significance
TSSA(exdat, m = 5, sig = TRUE)
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
Keiko Sakai \email{keiko.sakai@oit.ac.jp}
}
\references{
Takeya, M. (1991). \emph{A new test theory: Structural analyses for educational information}.
Tokyo: Waseda University Press.
}
\seealso{
\code{\link{SSRA}}, \code{\link{seqtable}}, \code{\link{scatterplot}}
}

