\name{SOAPServerDescription}
\alias{SOAPServerDescription}
\title{Constructor for describing methods and data structures of a SOAP server}
\description{
  This function creates an instance of the class
  \code{SOAPServerDescription}
  (or the value of \code{obj})
  and populates it with the specified collections of
  SOAP operations and data structure types, and
  information about the location of the SOAP server.
  This description can then be used to
  generate code to interface to the server's methods
  (see \code{\link{genSOAPClientInterface}}).
  The information is typically generated by reading the WSDL
  file, e.g. via \code{\link{processWSDL}}.
}
\usage{
SOAPServerDescription(name, server, operations, types,
                       nameSpaces = NA, verb = NA, obj = new("SOAPServerDescription"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{name}{a string (character vector) giving the name of the SOAP
    server. This typically comes from }
  \item{server}{an object of class SOAPServer that describes the
    location of the Web service, giving the URL, port, path to the services}
  \item{operations}{a list describing the operations or methods provided
  by the Web service}
  \item{types}{a list describing the data types used by the Web service}
  \item{obj}{an instance of the desired result whose slots are filled in
  during the call. This should be ``compatible'' with (i.e. extend) \code{\link{SOAPServerDescription}}.}
  \item{nameSpaces}{a character vector that identifies the
      namespace-URI mappings used for calls to this server.
      This maps the namespace abbreviations to the actual URIs.
      This can be a named character vector of these mappings, or
      alternatively a simple character string that identifies the name of
      the element in the \code{.SOAPDefaultNameSpaces} list.
      And if we don't know the collection of namespaces, we use
      \code{NA} to indicate that we shall determine this later.}
   \item{verb}{a string identifying the type of the binding/transport to
     use, i.e. \code{"POST"}, \code{"GET"} or \code{NA} for regular SOAP.}
}
\value{
  The object \code{obj} returned with the relevant
  fields filled in with values 
}
\references{
  \url{http://www.w3.org/TR/SOAP/}
  \url{http://www.omegahat.org/SSOAP}
}
\author{Duncan Temple Lang <duncan@wald.ucdavis.edu>}

\seealso{
  \code{\link{processWSDL}}  
}
\examples{

}
\keyword{interface}

