% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glance.R
\name{glance.SSN2}
\alias{glance.SSN2}
\alias{glance.ssn_lm}
\alias{glance.ssn_glm}
\title{Glance at a fitted model object}
\usage{
\method{glance}{ssn_lm}(x, ...)

\method{glance}{ssn_glm}(x, ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A single-row tibble with columns
\itemize{
\item \code{n} The sample size.
\item \code{p} The number of fixed effects.
\item \code{npar} The number of estimated covariance parameters.
\item \code{value} The optimized value of the fitting function
\item \code{AIC} The AIC.
\item \code{AICc} The AICc.
\item \code{logLik} The log-likelihood
\item \code{deviance} The deviance.
\item \code{pseudo.r.squared} The pseudo r-squared
}
}
\description{
Returns a row of model
summaries from a fitted model object. Glance returns the same number of columns for all models
and estimation methods.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
glance(ssn_mod)
}
