% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DecisionTree.R
\name{SSLRDecisionTree}
\alias{SSLRDecisionTree}
\title{General Interface Decision Tree model}
\usage{
SSLRDecisionTree(
  max_depth = 30,
  w = 0.5,
  min_samples_split = 20,
  min_samples_leaf = ceiling(min_samples_split/3)
)
}
\arguments{
\item{max_depth}{A number from 1 to Inf.
Is the maximum number of depth in Decision Tree
Default is 30}

\item{w}{weight parameter ranging from 0 to 1. Default is 0.5}

\item{min_samples_split}{the minimum number of observations to do split. Default is 20}

\item{min_samples_leaf}{the minimum number of any terminal leaf node. Default is ceiling(min_samples_split/3)}
}
\description{
Decision Tree is a simple and effective semi-supervised
learning method.
Based on the article "Semi-supervised classification trees".
It also offers many parameters to modify the behavior of this method.
It is the same as the traditional Decision Tree
algorithm, but the difference is how the gini coefficient is calculated (classification).
In regression we use SSE metric (different from the original investigation)
It can be used in classification or regression. If Y is numeric is for regression, classification in another case
}
\details{
In this model we can make predictions with prob type
}
\examples{
library(tidyverse)
library(caret)
library(SSLR)
library(tidymodels)

data(wine)

set.seed(1)
train.index <- createDataPartition(wine$Wine, p = .7, list = FALSE)
train <- wine[ train.index,]
test  <- wine[-train.index,]

cls <- which(colnames(wine) == "Wine")

#\% LABELED
labeled.index <- createDataPartition(wine$Wine, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- SSLRDecisionTree(min_samples_split = round(length(labeled.index) * 0.25),
                      w = 0.3,
                      ) \%>\% fit(Wine ~ ., data = train)


#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Wine", estimate = .pred_class)


#For probabilities
predict(m,test, type = "prob")

}
\references{
Jurica Levati, Michelangelo Ceci, Dragi Kocev, Saso Dzeroski.\cr
\emph{Semi-supervised classification trees.}\cr
Published online: 25 March 2017
© Springer Science Business Media New York 2017
}
