% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Div.R
\name{MakeFreq}
\alias{MakeFreq}
\alias{MakeMicro}
\title{Microdata frequency data conversion}
\usage{
MakeFreq(x, freqName = "freq", all = FALSE, hierarchies = FALSE)

MakeMicro(x, freqVar)
}
\arguments{
\item{x}{A data frame}

\item{freqName}{Name of new frequency variable in output data}

\item{all}{Whether to include level combinations not in microdata (zero frequency)}

\item{hierarchies}{Whether to treat hierarchical variables automatically when  \code{all=TRUE}}

\item{freqVar}{The frequency variable in input data, name or number.}
}
\value{
A data frame
}
\description{
Microdata frequency data conversion
}
\examples{
z <- SSBtoolsData("sprt_emp")[c(1, 2, 4, 7:12, 15, 17, 18), -4]
z$eu <- z$geo != "Iceland"
z

MakeFreq(z)
MakeFreq(z[, -2])
MakeFreq(z[, -(2:3)])
MakeFreq(z[, -1])
MakeFreq(z[, -1], all = TRUE)

x <- MakeFreq(z[, -1], all = TRUE, hierarchies = TRUE)
x

MakeMicro(x, "freq")
}
\keyword{internal}
