% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoSplit.r
\name{AutoSplit}
\alias{AutoSplit}
\title{Creating variables by splitting the elements of a character vector
without needing a split string}
\usage{
AutoSplit(s, split = NULL, border = "_", revBorder = FALSE,
  noSplit = FALSE, varNames = paste("var", 1:100, sep = ""),
  tryReverse = TRUE)
}
\arguments{
\item{s}{The character vector}

\item{split}{Split string. When NULL (default), automatic splitting without a split string.}

\item{border}{A split character 
or an integer (move split) to be used when the exact split position 
is not unique.}

\item{revBorder}{When border is integer the split position is moved from the other side.}

\item{noSplit}{No splitting when TRUE.}

\item{varNames}{Variable names of the created variables (too many is ok)}

\item{tryReverse}{When TRUE, the automatic method tries to find more variables by 
splitting from reversed strings.}
}
\value{
A data frame with s as row names.
}
\description{
Creating variables by splitting the elements of a character vector
without needing a split string
}
\examples{
s <- c("A12-3-A-x","A12-3-B-x","B12-3-A-x","B12-3-B-x",
       "A12-3-A-y","A12-3-B-y","B12-3-A-y","B12-3-B-y")
AutoSplit(s)
AutoSplit(s,border="-")
AutoSplit(s,split="-")
AutoSplit(s,border=1)
AutoSplit(s,border=2)
AutoSplit(s,border=2,revBorder=TRUE)
AutoSplit(s,noSplit=TRUE)
AutoSplit(s,varNames=c("A","B","C","D"))
}
\author{
Øyvind Langsrud
}
