% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchyCompute.R
\encoding{UTF8}
\name{HierarchyFix}
\alias{HierarchyFix}
\title{Change the hierarchy table to follow the standard}
\usage{
HierarchyFix(hierarchy, hierarchyVarNames = c(mapsFrom = "mapsFrom", mapsTo =
  "mapsTo", sign = "sign", level = "level"), autoLevel = TRUE)
}
\arguments{
\item{hierarchy}{data frame with hierarchy table}

\item{hierarchyVarNames}{variable names}

\item{autoLevel}{When TRUE, level is computed by automatic method}
}
\value{
data frame with hierarchy table
}
\description{
Make sure that variable names and sign coding follow an internal standard. Level may be computed automatically
}
\examples{
# Make input data by changing variable names and sign coding.
h <- SSBtoolsData("FIFA2018ABCD")[, 1:3]
names(h)[1:2] <- c("from", "to")
minus <- h$sign < 0
h$sign <- "+"
h$sign[minus] <- "-"

# Run HierarchyFix - Two levels created
HierarchyFix(h, c(mapsFrom = "from", mapsTo = "to", sign = "sign"))

# Extend the hierarchy table
h2 <- rbind(data.frame(from = c("Oceania", "Asia", "Africa", "America", "Europe"),
                       to = "World", sign = "+"),
           data.frame(from = c("World", "Europe"),
                      to = "nonEurope", sign = c("+", "-")), h)

# Run HierarchyFix - Three levels created
HierarchyFix(h2, c(mapsFrom = "from", mapsTo = "to", sign = "sign"))

}
