% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mostAbundant.R
\name{mostAbundant}
\alias{mostAbundant}
\title{Get the N most abundant rows (or columns) from a numeric table}
\usage{
mostAbundant(
  data,
  N = 10,
  items = NULL,
  others = FALSE,
  rescale = FALSE,
  bycol = FALSE
)
}
\arguments{
\item{data}{numeric matrix or data frame}

\item{N}{integer Number of rows to return (default \code{10}).}

\item{items}{Character vector. Custom row names to return. If provided, it will override \code{N} (default \code{NULL}).}

\item{others}{logical. If \code{TRUE}, an extra row will be returned containing the aggregated abundances of the elements not selected with \code{N} or \code{items} (default \code{FALSE}).}

\item{rescale}{logical. Scale result to percentages column-wise (default \code{FALSE}).}

\item{bycol}{logical. Operate on columns instead of rows (default \code{FALSE}).}
}
\value{
A matrix or data frame (same as input) with the selected rows (or columns).
}
\description{
Return a subset of an input matrix or data frame, containing only the N most abundant rows (or columns), sorted. Alternatively, a custom set of rows can be returned.
}
\examples{
data(Hadza)
Hadza.carb = subsetFun(Hadza, "Carbohydrate metabolism")
# Which are the 20 most abundant KEGG functions in the ORFs related to carbohydrate metabolism?
topCarb = mostAbundant(Hadza.carb$functions$KEGG$tpm, N=20)
# Now print them with nice names.
rownames(topCarb) = paste(rownames(topCarb),
                          Hadza.carb$misc$KEGG_names[rownames(topCarb)], sep="; ")
topCarb
# We can pass this to any R function.
heatmap(topCarb)
# But for convenience we provide wrappers for plotting ggplot2 heatmaps and barplots.
plotHeatmap(topCarb, label_y="TPM")
plotBars(topCarb, label_y="TPM")
}
