% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msi.dataset_methods.R
\name{varTransform,msi.dataset-method}
\alias{varTransform,msi.dataset-method}
\alias{varTransform}
\title{Variance stabilizing transformation.}
\usage{
\S4method{varTransform}{msi.dataset}(object, method = "log", offsetZero = 1)
}
\arguments{
\item{object}{\link{msi.dataset-class} object. See \link{msiDataset}.}

\item{method}{string (default = \code{log}). Transformation method.
Valid values are:
\itemize{
  \item "log", "log2", "log10": log-transformation defined as \code{log(x + offsetZero)}.
  \item "sqrt": square-root transformation.
  \item "clr": centered log-transformation. To be used when TIC scaling
  normalization is applied.
}}

\item{offsetZero}{numeric (default = 1). This value is added to all the peak
intensities to take into accounts of the zeros. It must be positive.}
}
\value{
\link{msi.dataset-class} object with transformed peaks intensities.
}
\description{
\code{varTransform} transforms the MS intensities in order to reduce heteroscedasticity.
}
\examples{
## Load package
library("SPUTNIK")

## Create the msi.dataset-class object
sz <- c(40, 40)
x <- matrix(rnorm(sz[1] * sz[2] * 20) * 1000, sz[1] * sz[2], 20)
x[x < 0] <- 0 # MS data is positive
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Normalize and log-transform
msiX <- normIntensity(msiX, "median")
msiX <- varTransform(msiX, "log")

## Create the msi.dataset-class object
sz <- c(40, 40)
x <- matrix(rnorm(sz[1] * sz[2] * 20) * 1000, sz[1] * sz[2], 20)
x[x < 0] <- 0 # MS data is positive
mz <- sort(sample(100, ncol(x)))
msiX <- msiDataset(x, mz, sz[1], sz[2])

## Normalize using PQN
msiX <- normIntensity(msiX, "PQN")
}
