% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.SPQR.R
\name{load.SPQR}
\alias{load.SPQR}
\title{load saved SPQR model}
\usage{
load.SPQR(name = stop("`name` must be specified"), path = NULL)
}
\arguments{
\item{name}{The name of the saved object excluding extension.}

\item{path}{The path to look for the saved object. Default is the current working directory.}
}
\value{
An object of class \code{SPQR}.
}
\description{
Load saved SPQR model from a designated path. The function first loads
the \code{.SPQR} file that stores the \code{SPQR} object. It then checks
whether the SPQR model is fitted with \code{method = "MCMC"}. If not, it also
loads the \code{.pt} file storing the \code{torch} model with the same \code{name}
and attach it to the \code{SPQR} object.
}
\examples{
\donttest{
set.seed(919)
n <- 200
X <- rbinom(n, 1, 0.5)
Y <- rnorm(n, X, 0.8)
fit <- SPQR(X = X, Y = Y, method = "MCMC", normalize = TRUE, verbose = FALSE)
# save.SPQR(fit, name = "mcmc_fit")
# fit <- load.SPQR("mcmc_fit")
}

}
