% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPlot.R
\name{plot_function_surface}
\alias{plot_function_surface}
\title{Surface plot}
\usage{
plot_function_surface(
  f = function(x) {     rowSums(x^2) },
  lower = c(0, 0),
  upper = c(1, 1),
  type = "filled.contour",
  s = 100,
  xlab = "x1",
  ylab = "x2",
  zlab = "y",
  color.palette = terrain.colors,
  title = " ",
  levels = NULL,
  points1,
  points2,
  pch1 = 20,
  pch2 = 8,
  lwd1 = 1,
  lwd2 = 1,
  cex1 = 1,
  cex2 = 1,
  col1 = "blue",
  col2 = "red",
  ...
)
}
\arguments{
\item{f}{function to be plotted. The function should either be able to take two vectors or one matrix specifying sample locations. i.e. \code{z=f(X)} or \code{z=f(x2,x1)} where Z is a two column matrix containing the sample locations \code{x1} and \code{x2}.}

\item{lower}{boundary for x1 and x2 (defaults to \code{c(0,0)}).}

\item{upper}{boundary (defaults to \code{c(1,1)}).}

\item{type}{string describing the type of the plot:  \code{"filled.contour"} (default), \code{"contour"},
\code{"persp"} (perspective), or \code{"persp3d"} plot.
Note that "persp3d" is based on the plotly package and will work in RStudio, but not in the standard RGui.}

\item{s}{number of samples along each dimension. e.g. \code{f} will be evaluated \code{s^2} times.}

\item{xlab}{lable of first axis}

\item{ylab}{lable of second axis}

\item{zlab}{lable of third axis}

\item{color.palette}{colors used, default is \code{terrain.color}}

\item{title}{of the plot}

\item{levels}{number of levels for the plotted function value. Will be set automatically with default NULL.. (contour plots  only)}

\item{points1}{can be omitted, but if given the points in this matrix are added to the plot in form of dots. Contour plots and persp3d only. Contour plots expect matrix with two columns for coordinates. 3Dperspective expects matrix with three columns, third column giving the corresponding observed value of the plotted function.}

\item{points2}{can be omitted, but if given the points in this matrix are added to the plot in form of crosses. Contour plots and persp3d only.  Contour plots expect matrix with two columns for coordinates. 3Dperspective expects matrix with three columns, third column giving the corresponding observed value of the plotted function.}

\item{pch1}{pch (symbol) setting for points1 (default: 20). (contour plots only)}

\item{pch2}{pch (symbol) setting for points2 (default: 8). (contour plots only)}

\item{lwd1}{line width for points1 (default: 1). (contour plots only)}

\item{lwd2}{line width for points2 (default: 1). (contour plots only)}

\item{cex1}{cex for points1 (default: 1). (contour plots only)}

\item{cex2}{cex for points2 (default: 1). (contour plots only)}

\item{col1}{color for points1 (default: "black"). (contour plots only)}

\item{col2}{color for points2 (default: "black"). (contour plots only)}

\item{...}{additional parameters passed to \code{contour} or \code{filled.contour}}
}
\value{
plotly visualization (based on \code{\link[plotly]{plot_ly}})
}
\description{
A (filled) contour plot or perspective plot of a function, interactive via plotly.
}
