% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spot.R
\name{spotControl}
\alias{spotControl}
\title{spotControl}
\usage{
spotControl(dimension = NA)
}
\arguments{
\item{dimension}{problem dimension, that is, the number of optimized parameters. This parameter is mandatory since v2.8.4.}
}
\value{
a list
}
\description{
Default Control list for spot.
This function returns the default controls for the functions \code{\link{spot}} and \code{\link{spotLoop}}.
}
\details{
Control is a list of the settings:
\describe{
  \item{\code{design}}{A function that creates an initial design of experiment. Functions that accept the same parameters,
			and return a matrix like \code{\link{designLHD}} or \code{\link{designUniformRandom}} can be used. Default is \code{\link{designLHD}}.}
  \item{\code{designControl}}{A list of controls passed to the \code{control} list of the \code{design} function. See help
			of the respective function for details. Default is an empty \code{list}.}
  \item{\code{directOpt}}{A function that is used to optimize after the \code{spot} run is finished.
   Functions that accept the same parameters, and return a matrix like \code{\link{optimNLOPTR}}
			or \code{\link{optimDE}} can be used. Default is \code{\link{optimNLOPTR}}.}
  \item{\code{directOptControl}}{A list of controls, which determine whether a direct optimization
  (exploitation of the final search region) is performed. Default is to run no direct optimization, i.e.,
  \code{directOptControl = list(funEvals = 0)list}.
  \describe{
  \item{\code{funEvals}}{This is the budget of function evaluations of the direct optimization performed
  after the SMBO is performed. Default is \code{list(funEvals = 0)}.}
  }
  }
  \item{\code{duplicate}}{In case of a deterministic (non-noisy) objective function, this handles duplicated candidate solutions.
			By default (\code{duplicate = "EXPLORE"}), duplicates are replaced by new candidate solutions, generated by random
			sampling with uniform distribution. If desired, the user can set this to "STOP", which means that the optimization
			stops and results are returned to the user (with a warning). This may be desirable, as duplicates can be a indicator
			for convergence, or for a problem with the configuration.
			In case of noise, duplicates are allowed.}
  \item{\code{funEvals}}{This is the budget of function evaluations (spot uses no more than funEvals evaluations of fun), defaults to 20.}
 \item{\code{handleNAsMethod}}{A function that treats NAs if there are any present in the result vector of the objective function.
             Default: \code{NULL}. By default NAs will not be treated.}
  \item{\code{infillCriterion}}{A function defining an infillCriterion to be used while optimizing a model. Default: NULL. For example check infillExpectedImprovement}
  \item{\code{model}}{A function that builds a statistical model of the observed data. Functions that accept the same
			parameters, and return a matrix like \code{\link{buildKriging}} or \code{\link{buildRandomForest}}
			can be used. Default is \code{\link{buildKriging}}.}
  \item{\code{modelControl}}{A list of controls passed to the \code{control} list of the \code{model} function.
			See help of the respective function for details. Default is an empty \code{list}.}
  \item{\code{multiStart}}{Number of restarts for optimization on the surrrogate
  model. Default: \code{1}, i.e., no restarts.}
  \item{\code{noise}}{Boolean, whether the objective function has noise or not. Default is non-noisy, that is, \code{FALSE}.}
  \item{\code{OCBA}}{Boolean, indicating whether Optimal Computing Budget Allocation (OCBA) should be used in case of a noisy
			objective function or not. OCBA controls the number of replications for each candidate solution.
				Note, that \code{replicates} should be larger than one in that case, and that the initial experimental design
			(see \code{design}) should also have replicates larger one. Default is \code{FALSE}.}
  \item{\code{OCBABudget}}{The number of objective function evaluations that OCBA can distribute in each iteration.
  Default is 3.}
  \item{\code{optimizer}}{A function that is used to optimize based on \code{model}, finding the most promising
			candidate solutions. Functions that accept the same parameters, and return a matrix like \code{\link{optimLHD}}
			or \code{\link{optimDE}} can be used. Default is \code{\link{optimLHD}}.}
  \item{\code{optimizerControl}}{A list of controls passed to the \code{control} list of the \code{optimizer} function.
			See help of the respective function for details. Default is an empty \code{list}.}
  \item{\code{parNames}}{ Vector of parameter names of each variable as a string, defaults \code{c("x1", "x2", "x3",..)}.}
  \item{\code{plots}}{Whether progress should be tracked by a line plot, default is \code{FALSE}}
  \item{\code{progress}}{Whether progress should be visualized, default is \code{FALSE}}
  \item{\code{replicates}}{The number of times a candidate solution is initially evaluated, that is, in the initial design,
			or when created by the optimizer. Default is \code{1}.}
  \item{\code{replicateResult}}{\code{logical}. If \code{TRUE}, one result is
  replicated. The result is specified as  the \code{lower} vector and
  re-evaluated \code{funEvals} times. No model building and
  optimization is performed, only evaluations on the
  objective function. Default: \code{FALSE}.}
 \item{\code{returnFullControlList}}{\code{logical}. Return the full control
 list. Can be switched off to save memory/space. Default: \code{TRUE}.}
  \item{\code{seedFun}}{An initial seed for the objective function in case of noise, by default \code{NA}. The default means that no seed is set.
			The user should be very careful with this setting. It is intended to generate reproducible experiments for each objective
			function evaluation, e.g., when tuning non-deterministic algorithms. If the objective function uses a constant number
			of random number generations, this may be undesirable. Note, that this seed is by default set prior to each evaluation. A replicated
			evaluation will receive an incremented value of the seed.
			Sometimes, the user may want to call external code using random numbers. To allow for that case, the user can specify an objective function (\code{fun}),
				which has a second parameter \code{seed}, in addition to first parameter (matrix \code{x}). This seed can then be passed
			to the external code, for random number generator initialization. See end of examples section for a demonstration.}
  \item{\code{seedSPOT}}{This value is used to initialize the random number generator. It ensures that experiments are reproducible. Default is \code{1}.}
  \item{\code{subsetSelect}}{A function that selects a subset from a given set of design points. Default is \code{\link{selectAll}}.}
  \item{\code{subsetControl}}{A list of controls passed to the \code{control} list of the \code{subsetSelect} function. See help
			of the respective function for details. Default is an empty \code{list}.}
  \item{\code{time}}{List with the following time information:
  \describe{
  \item{\code{maxTime}}{\code{num} Maximum allowed run time (in minutes) for \code{spot} or \code{spotLoop}.
         The default value for \code{maxTime} (in minutes) is \code{Inf} and can be overwritten by the user.
         The internal value \code{startTime}, that is used to control \code{maxTime},
         will be set by \code{\link{spotFillControlList}}.
         Note: \code{maxTime}  is only an approximate value. It does not affect the \code{directOpt} run.}
  \item{\code{startTime}}{Start time. Will be set in \code{\link{spotFillControlList}}.}
  \item{\code{endTime}}{End time.}
  }
 }
  \item{\code{types}}{ Vector of data type of each variable as a string, defaults \code{"numeric"} for all variables.}
  \item{\code{verbosity}}{Integer level specifying how much output should be given by SPOT. 0 (default) ignores warnings of internal optimizers /models.
             1 will show warnings and output.}
}
}
