% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportSeverity.R
\name{getPower}
\alias{getPower}
\title{getPower}
\usage{
getPower(mu0, mu1, n, sigma, alpha, tdist = FALSE, alternative = "greater")
}
\arguments{
\item{mu0}{mean value of the null hypothesis (usually referred to as H0)}

\item{mu1}{mean value of the alternative hypothesis (usually referred to as H1)}

\item{n}{sample size}

\item{sigma}{sample s.d.}

\item{alpha}{error}

\item{tdist}{logical. Use Student t Distribution. Default: FALSE}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided", "greater" (default) or "less".}
}
\description{
Implements basic power calculations in R
See also: \url{https://www.cyclismo.org/tutorial/R/power.html}
}
\examples{
## Power should be approx. 0.9183621:
getPower(mu0=5, mu1=6.5, n=20, sigma=2, alpha=0.05, tdist = FALSE, 
alternative = "two.sided")
## Power should be approx. 0.8887417:
getPower(mu0=5, mu1=6.5, n=20, sigma=2, alpha=0.05, tdist = TRUE, 
alternative = "two.sided")
## Compare with results from power.t.test
powerVal <- power.t.test(n=20, delta=1.5, sd=2, sig.level=0.05, type="one.sample",
alternative="two.sided",strict = TRUE)
powerVal$power

}
