% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelMarkovChain.R
\name{preprocessCdeTestData}
\alias{preprocessCdeTestData}
\title{preprocessCdeTestData}
\usage{
preprocessCdeTestData(testData)
}
\arguments{
\item{testData}{data frame with location information:
\describe{
\item{\code{ForecastId}}{int Identifier 1 2 3 ...} 
\item{\code{Province_State}}{chr Province/State} 
\item{\code{Country_Region}}{chr Country/Region, e.g., "Afghanistan" ...} 
\item{\code{Date}}{Date, format: "2020-04-02"  ...} 
}}
}
\value{
A data frame that can be processed by \code{\link{generateMCPrediction}}
to predict results on test data using the tuned \code{\{link{modelMarkovChain}} model.
Data.frame with $n$ obs. of  3 variables:
\describe{
\item{\code{ForecastId}}{int Identifier 1 2 3 ...} 
\item{\code{Region}}{Factor w/ m levels, e.g., "Afghanistan/",..: 1 1 1 1 1 1 1 1 1 1 ...} 
\item{\code{Date}}{Date, format: "2020-04-02"  ...} 
}
}
\description{
Rename variables and factorize location information.
}
\details{
The variable \code{location} is renamed to \code{Region} and converted 
to a factor variable.
}
\examples{
\dontrun{
testData <- preprocessCdeTestData(cde20200813)
}
}
