% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildLOESS.R
\name{buildLOESS}
\alias{buildLOESS}
\title{Build LOESS Model}
\usage{
buildLOESS(x, y, control = list())
}
\arguments{
\item{x}{design matrix (sample locations), rows for each sample, columns for each variable.}

\item{y}{vector of observations at \code{x}}

\item{control}{named list, with the options for the model building procedure loess. These
will be passed to loess as arguments. Please refrain from setting the formula or data arguments
as these will be supplied by the interface, based on \code{x} and \code{y}.}
}
\value{
returns an object of class \code{spotLOESS}.
}
\description{
Build an interpolation model using the \code{loess} function. Essentially a SPOT-style
interface to that function.
}
\examples{
## Create a test function: branin
braninFunction <- function (x) {	
	(x[2]  - 5.1/(4 * pi^2) * (x[1] ^2) + 5/pi * x[1]  - 6)^2 + 
10 * (1 - 1/(8 * pi)) * cos(x[1] ) + 10
}
## Create design points
set.seed(1)
x <- cbind(runif(40)*15-5,runif(40)*15)
## Compute observations at design points
y <- as.matrix(apply(x,1,braninFunction))
## Create model with default settings
fit <- buildLOESS(x,y)
fit
## Predict new point
predict(fit,cbind(1,2))
## True value at location
braninFunction(c(1,2))
## Change model control
fit <- buildLOESS(x,y,control=list(parametric=c(TRUE,FALSE)))
fit

}
\seealso{
\code{\link{predict.spotLOESS}}
}
