% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knockoffs.R
\name{knockoffHMM}
\alias{knockoffHMM}
\title{Group knockoffs of hidden Markov models}
\usage{
knockoffHMM(X, pInit, Q, pEmit, groups = NULL, seed = 123,
  cluster = NULL, display_progress = FALSE)
}
\arguments{
\item{X}{an integer matrix of size n-by-p containing the original variables.}

\item{pInit}{an array of length K, containing the marginal distribution of the states for the first variable.}

\item{Q}{an array of size (p-1,K,K), containing a list of p-1 transition matrices between the K states of the Markov chain.}

\item{pEmit}{an array of size (p,M,K), containing the emission probabilities for each of the M possible emission states,
from each of the K hidden states and the p variables.}

\item{groups}{an array of length p, describing the group membership of each variable (default: NULL).}

\item{seed}{an integer random seed (default: 123).}

\item{cluster}{a computing cluster object created by \link[parallel]{makeCluster} (default: NULL).}

\item{display_progress}{whether to show progress bar (default: FALSE).}
}
\value{
An integer matrix of size n-by-p containing the knockoff variables.
}
\description{
This function constructs knockoffs of variables distributed as a hidden Markov model.
}
\details{
Each element of the matrix X should be an integer value between 0 and M-1.
The transition matrices contained in Q are defined with the same convention as in \link{knockoffDMC}.
The emission propability matrices contained in pEmit are defined such that \eqn{P[X_{j}=k|H_{j}=l]=\mathrm{pEmit}[j,k,l]},
where \eqn{H_j} is the latent variable associated to \eqn{X_j}.
}
\examples{
# Generate data
p=10; K=5; M=3;
pInit = rep(1/K,K)
Q = array(stats::runif((p-1)*K*K),c(p-1,K,K))
for(j in 1:(p-1)) { Q[j,,] = Q[j,,] / rowSums(Q[j,,]) }
pEmit = array(stats::runif(p*M*K),c(p,M,K))
for(j in 1:p) { pEmit[j,,] = pEmit[j,,] / rowSums(pEmit[j,,]) }
X = sampleHMM(pInit, Q, pEmit, n=20)
# Generate knockoffs
Xk = knockoffHMM(X, pInit, Q, pEmit)
# Generate group-knockoffs for groups of size 3
groups = rep(seq(p), each=3, length.out=p)
Xk = knockoffHMM(X, pInit, Q, pEmit, groups=groups)

}
\references{
\insertRef{sesia2019}{SNPknock}
  \insertRef{sesia2019multi}{SNPknock}
}
\seealso{
Other knockoffs: \code{\link{knockoffDMC}},
  \code{\link{knockoffGenotypes}},
  \code{\link{knockoffHaplotypes}}
}
\concept{knockoffs}
