% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik.smle}
\alias{logLik.smle}
\alias{logLik.selection}
\title{Extract log-likelihood}
\usage{
\method{logLik}{smle}(object, ...)

\method{logLik}{selection}(object, ...)
}
\arguments{
\item{object}{An object of class \code{'smle'} or \code{'sdata'}.}

\item{...}{Forwarded arguments.}
}
\value{
Returns an object of class \code{'logLik'}. This is a number with at least one attribute,
 \code{"df"} (degrees of freedom), giving the number of (estimated) parameters in the model. For more details, see the generic \code{\link[stats]{logLik}()} in \pkg{stats}.
}
\description{
This is a method written to extract the log-likelihood from \code{'smle'} and \code{'selection'} objects. 
It refits the model by \code{\link[stats]{glm}()} based on the response and the selected features after screening (selection), 
and returns an object of \code{'logLik'} from the generic.
}
\examples{
set.seed(1)
Data<-Gen_Data(n=100, p=5000, family = "gaussian", correlation="ID")
fit<-SMLE(Y=Data$Y, X=Data$X, k=9, family = "gaussian")
logLik(fit)

}
