% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDQts.R
\name{edqts}
\alias{edqts}
\title{Empirical Dynamic Quantile for Visualization of High-Dimensional Time Series}
\usage{
edqts(x, p = 0.5, h = 30)
}
\arguments{
\item{x}{T by k data matrix: T data points in rows with each row being data at a given time point,
and k time series in columns.}

\item{p}{Probability, the quantile series of which is to be computed. Default value is 0.5.}

\item{h}{Number of time series observations used in the algorithm. The larger h is the longer to compute.
Default value is 30.}
}
\value{
The column of the matrix x which stores the "p" EDQ of interest.
}
\description{
Compute empirical dynamic quantile (EDQ) for a given probability "p" based on the weighted algorithm
 proposed in the article by Peña, Tsay and Zamar (2019).
}
\examples{
data(TaiwanAirBox032017)
edqts(TaiwanAirBox032017[,1:25])

}
\references{
Peña, D. Tsay, R. and Zamar, R. (2019). Empirical Dynamic Quantiles for
Visualization of High-Dimensional Time Series, \emph{Technometrics}, 61:4, 429-444.
}
