% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{reQueen}
\alias{reQueen}
\title{Re-queen}
\usage{
reQueen(x, queen, removeVirginQueens = TRUE)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{queen}{\code{\link{Pop-class}} with one individual that will be the
queen of the colony; if she is not mated, she will be added as a virgin
queen that will have to be mated later; test will be run if the individual
\code{\link{isVirginQueen}} or \code{\link{isQueen}}}

\item{removeVirginQueens}{logical, remove existing virgin queens, default is
\code{\link{TRUE}} since bee-keepers tend to remove any virgin queen cells
to ensure the provided queen prevails (see details)}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}} with new queen(s) (see details)
}
\description{
Level 2 function that re-queens a Colony or
  MultiColony object by adding a mated or a virgin queen, removing the
  previous queen, and changing the colony id to the new mated queen.
}
\details{
If the provided queen is mated, then she is saved in the queen slot
  of the colony. If she is not mated, then she is saved in the virgin queen
  slot (replacing any existing virgin queens) and once she is mated will be
  promoted to the queen of the colony.
}
\examples{
founderGenomes <- quickHaplo(nInd = 12, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 200)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 7, nDrones = nFathersPoisson)

# Create and cross Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[2:3])

# Check queen and virgin queens IDs
getCasteId(colony, caste = "queen")
getCasteId(colony, caste = "virginQueens")
getCasteId(apiary, caste = "queen")
getCasteId(apiary, caste = "virginQueens")

# Requeen with virgin queens
virginQueens <- basePop[5:8]
# Requeen a Colony class
colony <- reQueen(colony, queen = virginQueens[1])
# Check queen and virgin queens IDs
getCasteId(colony, caste = "queen")
getCasteId(colony, caste = "virginQueens")

#' # Requeen with mated queens
matedQueens <- cross(x = basePop[9:12], drones = droneGroups[4:7])
colony <- reQueen(colony, queen = matedQueens[1])
# Check queen and virgin queens IDs
getCasteId(colony, caste = "queen")
getCasteId(colony, caste = "virginQueens")

# Requeen a MultiColony class
apiary <- reQueen(apiary, queen = virginQueens[2:3])
# Check queen and virgin queens IDs
getCasteId(apiary, caste = "queen")
getCasteId(apiary, caste = "virginQueens")

}
