% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L3_Colonies.R
\name{pullColonies}
\alias{pullColonies}
\title{Pull out some colonies from the MultiColony object}
\usage{
pullColonies(
  multicolony,
  ID = NULL,
  n = NULL,
  p = NULL,
  by = NULL,
  pullTop = TRUE
)
}
\arguments{
\item{multicolony}{\code{\link{MultiColony-class}}}

\item{ID}{character or numeric, ID of a colony (one or more) to be pulled
out}

\item{n}{numeric, number of colonies to select}

\item{p}{numeric, percentage of colonies pulled out (takes precedence
over \code{n})}

\item{by}{matrix, matrix of values to select by with names being
colony IDs (can be obtained with \code{\link{calcColonyValue}}.
If NULL, the colonies are pulled at random.
This parameter is used in combination
with \code{n} or \code{p} to determine the number of pulled colonies, and
\code{pullTop} to determine whether to pull the best or the worst colonies.}

\item{pullTop}{logical, pull highest (lowest) values if \code{TRUE} (\code{FALSE})}
}
\value{
list with two \code{\link{MultiColony-class}}, the \code{pulled}
  and the \code{remnant}
}
\description{
Level 3 function that pulls out some colonies
  from the MultiColony based on colony ID or random selection.
}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
mean <- c(10, 10 / SP$nWorkers)
varA <- c(1, 1 / SP$nWorkers)
corA <- matrix(data = c(
  1.0, -0.5,
  -0.5, 1.0
), nrow = 2, byrow = TRUE)
varE <- c(3, 3 / SP$nWorkers)
varA / (varA + varE)
SP$addTraitADE(nQtlPerChr = 100,
               mean = mean,
               var = varA, corA = corA,
               meanDD = 0.1, varDD = 0.2, corD = corA,
               relAA = 0.1, corAA = corA)
SP$setVarE(varE = varE)

basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1:4], nInd = 100)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)
apiary <- createMultiColony(basePop[2:5], n = 4)
apiary <- cross(apiary, drones = droneGroups[1:4])
apiary <- buildUp(apiary)
getId(apiary)

tmp <- pullColonies(apiary, ID = c(1, 2))
getId(tmp$pulled)
getId(tmp$remnant)

tmp <- pullColonies(apiary, ID = c("3", "4"))
getId(tmp$pulled)
getId(tmp$remnant)

tmp <- pullColonies(apiary, n = 2)
getId(tmp$pulled)
getId(tmp$remnant)

tmp <- pullColonies(apiary, p = 0.75)
getId(tmp$pulled)
getId(tmp$remnant)

# How to pull out colonies based on colony values?
colonyGv <- calcColonyGv(apiary)
pullColonies(apiary, n = 1, by = colonyGv)
}
