% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dichotomize.meta.dataset.R
\name{dichotomize.meta.dataset}
\alias{dichotomize.meta.dataset}
\title{Dichotomize and unlist a meta-analysis list}
\usage{
dichotomize.meta.dataset(feature.name, expression.data, survival.data,
  other.data = NULL, data.type.ordinal = FALSE,
  centre.data = "median")
}
\arguments{
\item{feature.name}{Character indicate what feature (gene/probe/etc.) should
be extracted for analysis}

\item{expression.data}{A list where each component is an expression matrix
(patients = columns, genes = rows) for a different dataset}

\item{survival.data}{A list where each component is an object of class Surv}

\item{other.data}{A list of other covariates to be unlisted in the final
output (all elements in this list are used)}

\item{data.type.ordinal}{Logical indicating whether to treat this datatype
as ordinal. Defaults to FALSE}

\item{centre.data}{A character string specifying the centre value to be used for 
scaling data. Valid values are: 'median', 'mean', or a user defined numeric threshold
e.g. '0.3' when modelling methylation beta values. This value is used for both scaling
as well as for dichotomising data for estimating univariate betas from Cox model.
Defaults to 'median'}
}
\value{
Returns a list containing components groups (after dichotomization),
survtime (in the units of the input data), and survstat.
Additional vectors are unlisted from other.data if that parameter is not
NULL.
}
\description{
Takes a meta-analysis list (and possibly extra data) and dichotomizes
based on a specific gene, then returns the unlisted data to the caller.
}
\details{
NB: other.data handling of missing components (i.e. those present in only
some datasets) has not been debugged (but may work regardless).
}
\examples{

data.directory <- get.program.defaults()[["test.data.dir"]];
data.types <- c("mRNA");
x1 <- load.cancer.datasets(
  datasets.to.load = c('Breastdata1'),
  data.types = data.types,
  data.directory = data.directory
  );
x2 <- dichotomize.meta.dataset(
  feature.name = "1000_at",
  expression.data = x1$all.data[[data.types[1]]],
  survival.data = x1$all.survobj
  );

}
\author{
Syed Haider & Paul C. Boutros
}
\keyword{survival}
