% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSI.R
\name{plotPath}
\alias{plotPath}
\title{Coefficients path plot}
\usage{
plotPath(fm, Z = NULL, K = NULL, indexK = NULL, 
   tst = NULL, title = NULL, maxCor = 0.85)
}
\arguments{
\item{fm}{An object of the 'LASSO' or 'SSI' class}

\item{Z}{(numeric matrix) Design matrix for random effects. When \code{Z=NULL} an identity matrix is considered (default) thus \ifelse{html}{\out{<b>G</b> = <b>K</b>}}{\eqn{\textbf{G = K}}{G = K}}; otherwise \ifelse{html}{\out{<b>G</b> = <b>Z K Z'</b>}}{\eqn{\textbf{G} = \textbf{Z K Z'}}{G = Z K Z'}} is used. Only needed for a \code{fm} object of the class 'SSI'}

\item{K}{(numeric matrix) Kinship relationships. This can be a name of a binary file where the matrix is stored. Only needed for a \code{fm} object of the class 'SSI'}

\item{indexK}{(integer vector) Which columns and rows will be read when \code{K} is the name of a binary file. Default \code{indexK=NULL} will read the whole matrix}

\item{tst}{(integer vector) Which individuals are in testing set and to plot. It must be contained in \code{fm$tst}. Default \code{tst=NULL} will consider the whole vector \code{fm$tst} to plot}

\item{title}{(character/expression) Title of the plot}

\item{maxCor}{(numeric) Maximum correlation allowed for two different coefficients. A group of coeffcients with a correlation greater than \code{maxCor} are likely to overlap in the plot thus only one is kept}
}
\value{
Returns the plot of the coefficients' evolution path along the regularization parameter
}
\description{
Coefficients evolution path plot from an object of the class 'LASSO' or 'SSI'
}
\examples{
  require(SFSI)
  data(wheatHTP)
  
  X = scale(X[1:300,])/sqrt(ncol(X))   # Subset and scale markers
  G = tcrossprod(X)                    # Genomic relationship matrix
  y = as.vector(scale(Y[1:300,"YLD"])) # Subset response variable
  WL = scale(WL[1:300,])               # Reflectance data
  
  # Sparse phenotypic regression
  fm1 = lars2(var(WL),cov(y,WL))
  
  # Sparse family index
  fm2 = SSI(y,K=G,tst=1:15,trn=16:length(y))
  
  \donttest{
  plotPath(fm1)
  plotPath(fm2,maxCor=0.6)
  plotPath(fm2,K=G,maxCor=0.6)
  }
  
  # Path plot for the first individual in testing set for the SSI
  plotPath(fm2,K=G,tst=fm2$tst[1])
}
\author{
Marco Lopez-Cruz (\email{maraloc@gmail.com}) and Gustavo de los Campos
}
