#' Data Collected in the New York Bight
#' 
#' Data collected in the New York Bight for June 1974 and 
#' June 1975 (Wilk et al. 1977)
#' @name nybight
#' @docType data
#' @format Data frame with the following 7 variables: 
#' \describe{
#'   \item{year}{year}
#'   \item{stratum}{stratum membership, based on depth}
#'   \item{catchnum}{number of fish caught during trawl}
#'   \item{catchwt}{total weight (kg) of fish caught during trawl}
#'   \item{numspp}{number of species of fish caught during trawl}
#'   \item{depth}{depth of station (m)}
#'   \item{temp}{surface temperature (degrees Celsius)}
#' }
#' @note Two of the original strata were combined because of insufficient 
#'   sample sizes.
#' @source Wilk, S.J. et al. (1977). Fishes and associated environmental
#'   data collected in New York bight, June 1974 - June 1975. NOAA Technical
#'   Report NMFS SSRF-716. Washington, D.C: Government Printing Office.
#' @references Lohr (1999). Sampling: Design and Analysis, Duxbury, p. TODO and
#'   443.
#' @export
roxygen()
