% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDMdata.quality.R
\name{SDMdata.quality}
\alias{SDMdata.quality}
\title{Evaluate dataset quality}
\usage{
SDMdata.quality(data)
}
\arguments{
\item{data}{\link{SDMtab} object or dataframe that contains id, longitude, latitude and values of environmental descriptors at corresponding locations}
}
\value{
prop Dataframe that provides the proportion of NA values on which the presence data fall, for each environmental predictor
}
\description{
Evaluate the percentage of occurrences that fall on pixels assigned by NA values in the environmental RasterStack. It may provide interesting information to interpret model robustness.
}
\examples{
#Open SDMtab object example
x <- system.file ("extdata","SDMdata1500.csv", package="SDMPlay")
SDMdata <- read.table(x,header=TRUE, sep=";")

# Evaluate the dataset
SDMPlay:::SDMdata.quality(data=SDMdata)
}
\seealso{
\link{SDMeval}
}
