% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter_qi.R
\name{dupfilter_qi}
\alias{dupfilter_qi}
\title{Filter temporal duplicates by quality index}
\usage{
dupfilter_qi(sdata = sdata, step.time = 0)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}

\item{step.time}{Consecutive locations less than or equal to \emph{step.time} apart are considered temporal duplicates.
Default is 0 hours.}
}
\value{
The input data frame is returned with temporal duplicates removed by the quality index.
}
\description{
Function to filter temporal duplicates in tracking data by quality index.
}
\details{
This function is a partial component of \code{\link{dupfilter}}, although works as a stand-alone function. 
It looks for temporal duplicates and retains a fix with the highest quality index.
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
\emph{Marine Biology} 163:1-14 \doi{10.1007/s00227-015-2771-0}
}
\seealso{
\code{\link{dupfilter}}, \code{\link{dupfilter_exact}}, \code{\link{dupfilter_time}}, \code{\link{dupfilter_space}}, \code{\link{track_param}}
}
\author{
Takahiro Shimada
}
