% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter.R
\name{dupfilter}
\alias{dupfilter}
\title{Filter temporal and/or spatial duplicates}
\usage{
dupfilter(sdata, step.time = 0, step.dist = 0, conditional = FALSE)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
See the data \code{\link{turtle}} for an example.
The function filters the input data by a unique "id" (e.g. transmitter number, identifier for each animal). 
"DateTime" is the GMT date & time of each location in class \code{\link[base:DateTimeClasses]{POSIXct}} or \code{\link[base]{character}} with the following format "2012-06-03 01:33:46".
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the quality index associated with each location fix. 
The input values can be either the number of GPS satellites or Argos Location Classes. 
Argos Location Classes will be converted to numerical values, where "A", "B", "Z" will be replaced with "-1", "-2", "-3" respectively.
The greater number indicates a higher accuracy.}

\item{step.time}{Consecutive locations less than or equal to \emph{step.time} apart are considered temporal duplicates.
Default is 0 hours.}

\item{step.dist}{Consecutive locations less than or equal to \emph{step.dist} apart are considered spatial duplicates.
Default is 0 kilometres.}

\item{conditional}{If TRUE, spatial duplicates are filtered only if they are less than or equal to \emph{step.time} apart. 
Default is FALSE.}
}
\value{
The input data frame is returned containing only a single fix (latitude/longitude pair) per time and location.
}
\description{
Function to filter temporal and spatial duplicates in tracking data 
and retain only a single fix per time and location.
}
\details{
This function filters temporal and spatial duplicates in tracking data.
It first filters temporally and spatially exact locations. 
It then looks for temporal duplicates and retains a fix with the highest quality index.
When temporal or spatial duplicates are associated with the same quality index, 
the function retains a location that is nearest from a previous and to a subsequent location.
}
\examples{
#### Load data sets
## Fastloc GPS data obtained from a green turtle
data(turtle)


#### Apply dupfilter
turtle.dup <- dupfilter(turtle)
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
\emph{Marine Biology} 163:1-14 \doi{10.1007/s00227-015-2771-0}
}
\seealso{
\code{\link{dupfilter_exact}}, \code{\link{dupfilter_qi}}, \code{\link{dupfilter_time}}, \code{\link{dupfilter_space}}, \code{\link{track_param}}
}
\author{
Takahiro Shimada
}
