% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_param.R
\name{track_param}
\alias{track_param}
\title{Calculate parameters between locations}
\usage{
track_param(
  sdata,
  param = c("time", "distance", "speed", "angle", "mean speed", "mean angle"),
  days = 2
)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon". 
The function calculates each movement parameter by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. 
"lat" and "lon" are the latitude and longitude of each location in decimal degrees.}

\item{param}{A string or vector specifying movement parameters to be calculated.
Options are 'time', 'distance', 'speed', 'angle', 'mean speed' and 'mean angle'.
See \emph{details}.}

\item{days}{A numeric value specifying the number of days to calculate mean speeds and angles.
This argument is only used when 'mean speed' and/or 'mean angle' are selected in \emph{param}.}
}
\value{
The input data is returned with new columns containing the requested parameters. 
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively. 
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively. 
"pSpeed" and "sSpeed" are linear speed (km/h) from a previous and to a subsequent fix respectively. 
"inAng" is the degree between the bearings of lines joining successive location points.
"meanSpeed" and "meanAngle" are the mean speed and degree over a specified number of days.
}
\description{
Calculate time, distance, speed, and inner angle between successive locations
}
\details{
This function calculates various parameters of tracks. 
time (h), distance (km), speed (km/h) and inner angle (degrees) are calculated from each pair of successive locations.
mean speed (km/h) and angle (degrees) are calculated from locations over a specified number of days.
}
\examples{
#### Load turtle tracking data
data(turtle)


#### Filter temporal and/or spatial duplicates
turtle.dup <- dupfilter(turtle, step.time=5/60, step.dist=0.001)


#### ddfilter
turtle.dd <- ddfilter(turtle.dup, vmax=9.9, qi=4, ia=90, vmaxlp=2.0)


#### Mean speed over 2 days
mean.speed <- track_param(turtle.dd, param = c('speed', 'mean speed'), days=2)


#### Plot data
ggplot(data = mean.speed, aes(x=lon, y=lat)) +
geom_path(colour = 'grey') +
geom_point(aes(colour=meanSpeed))
}
\author{
Takahiro Shimada
}
