% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dupfilter.exact.r
\name{dupfilter.exact}
\alias{dupfilter.exact}
\title{Filter temporally and spatially exact duplicates}
\usage{
dupfilter.exact(sdata)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}
}
\value{
Input data frame is returned with temporally and spatially exact duplicates removed. 
The following columns are added: "pTime", "sTime", "pDist", "sDist". 
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively. 
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively.
}
\description{
A partial component of dupfilter, although works as a stand-alone function. 
This function removes temporally and spatially exact duplicates.
}
\details{
This function selects a fix from multiple fixes, which were simultaneously obtained at the same geographical coordinate.
}
\references{
Shimada T, Limpus C, Jones R, Hazel J, Groom R, Hamann M (2016) 
Sea turtles return home after intentional displacement from coastal foraging areas. 
Marine Biology 163:1-14 doi:10.1007/s00227-015-2771-0
}
\seealso{
\code{\link{dupfilter}}, \code{\link{dupfilter.qi}}, \code{\link{dupfilter.time}}, \code{\link{dupfilter.space}}
}
\author{
Takahiro Shimada
}
