% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfilter.loop.r
\name{ddfilter.loop}
\alias{ddfilter.loop}
\title{Filter locations by quality index, inner angle, and speed}
\usage{
ddfilter.loop(sdata, qi = 4, ia = 90, maxvlp = 1.8)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: 
"id", "DateTime", "lat", "lon", "qi". This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{qi}{An integer specifying threshold quality index during a loop trip. Default is 4 satellites.}

\item{ia}{An integer specifying threshold inner angle during a loop trip. Default is 90 degrees.}

\item{maxvlp}{A numeric value specifying threshold speed during a loop trip. Default is 1.8 km/h. 
If this value is unknown, the function "est.maxvlp" can be used to estimate the value based on the supplied data.}
}
\value{
A data frame is returned without locations identified by this filter.
The following columns are added: "pTime", "sTime", "pDist", "sDist", "pSpeed", "sSpeed", "inAng".
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively.
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively.
"pSpeed" and "sSpeed" are linear speed from a previous and to a subsequent fix respectively.
"inAng" is the angle between the bearings of lines joining successive location points.
}
\description{
A partial component of ddfilter, although works as a stand-alone function. 
This function removes locations by speed, inner angle, and quality index as described in Shimada et al. (2012).
}
\details{
This function removes locations if all of the following criteria apply: 
the number of source satellites are less than or equal to "qi", 
the inner angle is less than and equal to "ia" and the speed either from a previous or to a subsequent location exceeds "maxvlp". 
If "maxvlp" is unknown, it can be estimated using the function "est.maxvlp".
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) Improving data retention and home range estimates by data-driven screening. 
Marine Ecology Progress Series 457:171-180 doi:10.3354/meps09747
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter.speed}}, \code{\link{est.maxvlp}}
}
\author{
Takahiro Shimada
}
