% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_functions.R
\name{SDALGCPMCML_ST}
\alias{SDALGCPMCML_ST}
\title{Parameter estimation for spatio-temporal SDA-LGCP Using Monte Carlo Maximum likelihood}
\usage{
SDALGCPMCML_ST(
  formula,
  st_data,
  delta,
  phi = NULL,
  method = 1,
  pop_shp = NULL,
  kappa = 0.5,
  weighted = FALSE,
  par0 = NULL,
  control.mcmc = NULL,
  plot = FALSE,
  plot_profile = TRUE,
  rho = NULL,
  giveup = NULL,
  messages = FALSE
)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{st_data}{data frame containing the variables in the model and the polygons of the region, which of class spacetime.}

\item{delta}{distance between points}

\item{phi}{the discretised values of the scale parameter phi. if not supplied, it uses the default, which is 20 phis' which ranges from size of the smallest region to the one-tenth of the size of the entire domain.}

\item{method}{To specify which method to use to sample the points, the options are 1 for Simple Sequential Inhibition (SSI) process, 2 for Uniform sampling and 3 for regular grid. 1 is the default}

\item{pop_shp}{Optional, The raster of population density map for population weighted approach}

\item{kappa}{the smoothness parameter of the matern correlation function assumed for the temporal correlation, default to 0.5 which corresponds to exponential correlation function.}

\item{weighted}{To specify if you want to use the population density, default to FALSE, i.e population density is not used.}

\item{par0}{the initial parameter of the fixed effects beta, the variance sigmasq and the scale parameter phi, specified as c(beta, sigma2, phi). Default; beta, the estimates from the glm; sigma2, variance of the residual; phi, the median of the supplied phi.}

\item{control.mcmc}{list from PrevMap package to define the burnin, thining, the number of iteration and the turning parameters see \code{\link{controlmcmcSDA}}.}

\item{plot}{To display the plot of the points inside the polygon, default to TRUE}

\item{plot_profile}{logical; if TRUE the profile-likelihood is plotted. default is FALSE}

\item{rho}{Optional, the packing density, default set to 0.55}

\item{giveup}{Optional, number of rejected proposals after which the algorithm should terminate, default set to 1000}

\item{messages}{logical; if messages=TRUE, it prints the results objective function and the parameters at every phi iteration. Default is FALSE.}
}
\value{
An object of class "SDALGCP".
The function \code{\link{summary.SDALGCPST}} is used to print a summary of the fitted model.
The object is a list with the following components:

\code{D}: matrix of covariates.

\code{y}: the count, response observations.

\code{m}: offset

\code{beta_opt}: estimates of the fixed effects of the model.

\code{sigma2_opt}: estimates of the variance of the Gaussian process.

\code{phi_opt}: estimates of the scale parameter phi of the Gaussian process.

\code{cov}: covariance matrix of the MCML estimates.

\code{Sigma_mat_opt}: covariance matrix of the Gaussian process that corresponds to the optimal value

\code{llike_val_opt}: maximum value of the log-likelihood.

\code{mu}: mean of the linear predictor

\code{all_para}: the entire estimates for the different values of phi.

\code{all_cov}: the entire covariance matrix of the estimates for the different values of phi.

\code{par0}: the initial parameter of the fixed effects beta and the variance sigmasq used in the estimation

\code{control.mcmc}: the burnin, thining, the number of iteration and the turning parameters used see \code{\link{controlmcmcSDA}}.

\code{call}: the matched call.
}
\description{
This function provides the maximum likelihood estimation of the parameter given a set of values of scale parameter of the Gaussian process, phi.
}
\details{
This function performs parameter estimation for a SDALGCP Model
\bold{Monte Carlo Maximum likelihood.}
The Monte Carlo maximum likelihood method uses conditional simulation from the distribution of the random effect \eqn{T(x) = d(x)'\beta+S(x)} given the data \code{y}, in order to approximate the high-dimensional intractable integral given by the likelihood function. The resulting approximation of the likelihood is then maximized by a numerical optimization algorithm which uses analytic expression for computation of the gradient vector and Hessian matrix. The functions used for numerical optimization are \code{\link{nlminb}}. The first stage of estimation is generating locations inside the polygon, followed by precomputing the correlation matrices, then optimising the likelihood.
}
\examples{
# check vignette for examples
}
\references{
Giorgi, E., & Diggle, P. J. (2017). PrevMap: an R package for prevalence mapping. Journal of Statistical Software, 78(8), 1-29. doi:10.18637/jss.v078.i08

Christensen, O. F. (2004). Monte Carlo maximum likelihood in model-based geostatistics. Journal of Computational and Graphical Statistics 13, 702-718.
}
\seealso{
\link{Aggregated_poisson_log_MCML}, \code{\link{Laplace.sampling}},  \link{summary.SDALGCPST}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
