% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDALGCPParaEst}
\alias{SDALGCPParaEst}
\title{SDALGCPParaEst function.}
\usage{
SDALGCPParaEst(formula, data, corr, par0 = NULL, control.mcmc = NULL,
  plot_profile = FALSE, messages = FALSE)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{data frame containing the variables in the model.}

\item{corr}{the array of the precomputed correlation matrix for each value of the scale parameter.}

\item{par0}{the initial parameter of the fixed effects beta, the variance sigmasq and the scale parameter phi, specified as c(beta, sigma2, phi)}

\item{control.mcmc}{list from PrevMap package to define the burnin, thining, the number of iteration and the turning parameters see \code{\link{controlmcmcSDA}}.}

\item{plot_profile}{logical; if TRUE the profile-likelihood is plotted. default is FALSE}

\item{messages}{logical; if message=TRUE, it prints the results objective function and the parameters at every phi iteration. Default is FALSE.}
}
\value{
An object of class "SDALGCP".
The function \code{\link{summary.SDALGCP}} is used to print a summary of the fitted model.
The object is a list with the following components:

\code{D}: matrix of covariates.

\code{y}: the count, response observations.

\code{m}: offset

\code{beta_opt}: estimates of the fixed effects of the model.

\code{sigma2_opt}: estimates of the variance of the Gaussian process.

\code{phi_opt}: estimates of the scale parameter phi of the Gaussian process.

\code{cov}: covariance matrix of the MCML estimates.

\code{Sigma_mat_opt }: covariance matrix of the Gaussian process that corresponds to the optimal value

\code{llike_val_opt}: maximum value of the log-likelihood.

\code{mu}: mean of the linear predictor

\code{all_para}: the entire estimates for the different values of phi.

\code{all_cov}: the entire covariance matrix of the estimates for the different values of phi.

\code{par0}: the initial parameter of the fixed effects beta and the variance sigmasq used in the estimation

\code{control.mcmc}:  the burnin, thining, the number of iteration and the turning parameters used see \code{\link{controlmcmcSDA}}.

\code{S}: the linear predictor given the initial parameter

\code{call}: the matched call.
}
\description{
This function provides the maximum likelihood estimation of the parameter given the precomputed correlation matrices for different values of scale parameter, phi. An internal function for \code{\link{SDALGCP}} package
}
\details{
This function performs parameter estimation for a SDALGCP Model
\bold{Monte Carlo Maximum likelihood.}
The Monte Carlo maximum likelihood method uses conditional simulation from the distribution of the random effect \eqn{T(x) = d(x)'\beta+S(x)} given the data \code{y}, in order to approximate the high-dimensional intractable integral given by the likelihood function. The resulting approximation of the likelihood is then maximized by a numerical optimization algorithm which uses analytic expression for computation of the gradient vector and Hessian matrix. The functions used for numerical optimization are \code{\link{nlminb}}
}
\references{
Giorgi, E., & Diggle, P. J. (2017). PrevMap: an R package for prevalence mapping. Journal of Statistical Software, 78(8), 1-29. doi:10.18637/jss.v078.i08.

Christensen, O. F. (2004). Monte Carlo maximum likelihood in model-based geostatistics. Journal of Computational and Graphical Statistics 13, 702-718.
}
\seealso{
\link{Aggregated_poisson_log_MCML}, \code{\link{Laplace.sampling}}
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
