% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_GroupedGOTermPlot.R
\name{do_GroupedGOTermPlot}
\alias{do_GroupedGOTermPlot}
\title{Compute an overview of the GO terms associated with the input list of genes.}
\usage{
do_GroupedGOTermPlot(
  genes,
  org.db,
  levels.use = NULL,
  GO_ontology = "BP",
  min.overlap = NULL,
  flip = TRUE,
  legend.position = "right",
  heatmap_gap = 0.5,
  cluster_rows = TRUE,
  cluster_cols = TRUE,
  cell_size = 8,
  reverse.levels = TRUE,
  colors.use = c("grey90", "#29353d"),
  rotate_x_axis_labels = 45,
  font.size = 10,
  verbose = FALSE
)
}
\arguments{
\item{genes}{\strong{\code{\link[base]{character}}} | Vector of gene symbols to query for functional annotation.}

\item{org.db}{\strong{\code{OrgDB}} | Database object to use for the query.}

\item{levels.use}{\strong{\code{\link[base]{numeric}}} | Vector of numerics corresponding to the GO ontology levels to plot. If NULL will compute all recursively until there are no results.}

\item{GO_ontology}{\strong{\code{\link[base]{character}}} | GO ontology to use. One of:
\itemize{
\item \emph{\code{BP}}: For \strong{B}iological \strong{P}rocess.
\item \emph{\code{MF}}: For \strong{M}olecular \strong{F}unction.
\item \emph{\code{CC}}: For \strong{C}ellular \strong{C}omponent.
}}

\item{min.overlap}{\strong{\code{\link[base]{numeric}}} | Filter the output result to the terms which are supported by this many genes.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{heatmap_gap}{\strong{\code{\link[base]{numeric}}} | Gap in cm between heatmaps.}

\item{cluster_rows}{\strong{\code{\link[base]{logical}}} | Cluster the rows or rows of the heatmaps.}

\item{cluster_cols}{\strong{\code{\link[base]{logical}}} | Cluster the columns or rows of the heatmaps.}

\item{cell_size}{\strong{\code{\link[base]{numeric}}} | Size of each cell in the heatmap.}

\item{reverse.levels}{\strong{\code{\link[base]{logical}}} | Whether to place the higher levels first when computing the joint heatmap.}

\item{colors.use}{\strong{\code{\link[base]{character}}} | Vector of 2 colors to use in the heatmap. The first will correspond to the empty values and the second one to the genes present in the terms.}

\item{rotate_x_axis_labels}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{verbose}{\strong{\code{\link[base]{logical}}} | Whether to show extra comments, warnings,etc.}
}
\value{
A list containing all the matrices for the respective GO levels and all the individual and combined heatmaps.
}
\description{
Compute an overview of the GO terms associated with the input list of genes.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_GroupedGOTermPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Need to load this library or equivalent.
    suppressMessages(library("org.Hs.eg.db"))

    # Define list of genes to query.
    genes.use <- c("CCR7", "CD14", "LYZ",
                   "S100A4", "MS4A1",
                   "MS4A7", "GNLY", "NKG7", "FCER1A",
                   "CST3", "PPBP")

    # Compute the grouped GO terms.
    out <- SCpubr::do_GroupedGOTermPlot(genes = genes.use,
                                        org.db = org.Hs.eg.db)
  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
